/*
 * Demo   : ET-SENSOR SHT10
 *        : I2C Interface Sensor
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 * I2C    : SHT10(I2C:SCL=D3,SDA=D2)
 */

#include <Wire.h>
#include "SHT1x.h"

//=====================================
#define SHT10_SDA_PIN  2
#define SHT10_SCL_PIN  3
SHT1x SHT10(SHT10_SDA_PIN, SHT10_SCL_PIN);
//======================================
float sht10_temperature;
float sht10_humidity;
//======================================

//======================================
unsigned long lastGetI2CSensorTime = 0;
//======================================

void setup() 
{
  Serial.begin(115200);
  // Wait MEGA32U4 USB Serial Complete
  while(!Serial);
  Serial.println();
  Serial.println("SHT10...Test");
}
 
void loop() 
{ 
  //====================================
  // Start of Read I2C Sensor(BME280)
  //====================================
  if(millis() - lastGetI2CSensorTime > 5000ul)                        // 5-Second
  {
    sht10_temperature = SHT10.readTemperatureC();
    sht10_humidity = SHT10.readHumidity();

    Serial.print("SHT10 Temperature = ");
    Serial.print(sht10_temperature, 1);
    Serial.println("C");
    
    Serial.print("SHT10 Humidity = ");
    Serial.print(sht10_humidity,1);
    Serial.println("%");

    Serial.println();
    //==================================
    lastGetI2CSensorTime = millis();
    //==================================
  }
}

