/*
 * Demo   : ET-SENSOR BME280 
 *        : I2C Interface Sensor
 * MCU    : ESP8266
 *        : ESP-WROOM-02
 * I2C    : BME280(I2C:SCL=D1,SDA=D2)
 */

#include <Wire.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>

#define SCL_PIN         D1              // D1, ESP8266 : GPIO5  (***SCL***)
#define SDA_PIN         D2              // D2, ESP8266 : GPIO4  (***SDA***)
//======================================
Adafruit_BME280 bme280;                 // I2C
//======================================
#define SEALEVELPRESSURE_HPA (1013.25)
float bme280_temperature;
float bme280_humidity;
float bme280_pressure;  
float bme280_altitude;
bool  bme280_status;
//======================================
unsigned long lastGetI2CSensorTime = 0;
//======================================

void setup() 
{
  Serial.begin(115200);
  Serial.println();
  Serial.println("BME280 I2C(0x76) Test");
  
  Wire.begin(SDA_PIN,SCL_PIN);  
  bme280_status = bme280.begin(0x76);
  if(!bme280_status)
  {
    Serial.println("Initial BME280...Error");
    while(1);
  }
  Serial.println("Initial BME280...Complete");
  Serial.println();
}
 
void loop() 
{ 
  //====================================
  // Start of Read I2C Sensor(BME280)
  //====================================
  if(millis() - lastGetI2CSensorTime > 5000ul)                        // 5-Second
  {
    bme280_temperature  = bme280.readTemperature();                   // *C
    bme280_humidity     = bme280.readHumidity();                      // %RH
    bme280_pressure     = bme280.readPressure() / 100.0F;             // hPa 
    bme280_altitude     = bme280.readAltitude(SEALEVELPRESSURE_HPA);  // m
    //
    Serial.print("BME280 Temperature = ");
    Serial.print(bme280.readTemperature());
    Serial.println(" *C");
    
    Serial.print("BME280 Pressure = ");
    Serial.print(bme280.readPressure() / 100.0F);
    Serial.println(" hPa");
    
    Serial.print("BME280 Approx. Altitude = ");
    Serial.print(bme280.readAltitude(SEALEVELPRESSURE_HPA));
    Serial.println(" m");
    
    Serial.print("BME280 Humidity = ");
    Serial.print(bme280.readHumidity());
    Serial.println(" %");
    
    Serial.println();
    //==================================
    lastGetI2CSensorTime = millis();
    //==================================
  }
}

