/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : External OPTO-DC Input : ET-I2C-DCIN8 
 */

#include <Wire.h>                    // I2C Bus
#include "pcf8574.h"                 // PCF8574/A
//
#define SerialDebug Serial                                                                        // USB Serial
//
//===================================================================
#define SDA_I2C         D2           // PD1
#define SCL_I2C         D3           // PD0
//===================================================================

//===================================================================
PCF8574 PCF8574A_INPUT_EXP0(0x38);   // PCF8574A = 0111,000+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP1(0x39);   // PCF8574A = 0111,001+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP2(0x3A);   // PCF8574A = 0111,010+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP3(0x3B);   // PCF8574A = 0111,011+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP4(0x3C);   // PCF8574A = 0111,100+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP5(0x3D);   // PCF8574A = 0111,101+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP6(0x3E);   // PCF8574A = 0111,110+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP7(0x3F);   // PCF8574A = 0111,111+(0:W,1:R)
//===================================================================

uint8_t this_input;
uint8_t last_input;

void setup() 
{
  //=================================================================
  Wire.begin();                      // Initial I2C Bus
  //=================================================================
  PCF8574A_INPUT_EXP0.write8(0xFF);   
  last_input = 0xFF;
  //=================================================================
  SerialDebug.begin(115200);         // Debug USART
  while(!SerialDebug);               // wait USB Serial Complete 
  SerialDebug.println();
  SerialDebug.println("Demo Test ET-I2C DCIN8");
}

void loop() 
{
  this_input = PCF8574A_INPUT_EXP0.read8(); 
  if(this_input != last_input)
  {
    last_input = this_input;
    SerialDebug.print("Input = ");
    if(this_input == B01111111)
    SerialDebug.print("0");                 // 1111111 -> 01111111
    SerialDebug.println(this_input,BIN);    
  }
  delay(100);
}

