/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : ET-SENSOR BME280
 */

#include <Wire.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>

//======================================
Adafruit_BME280 bme280;                                               // I2C
//======================================
#define SEALEVELPRESSURE_HPA (1013.25)
float bme280_temperature;
float bme280_humidity;
float bme280_pressure;  
float bme280_altitude;
bool  bme280_status;
//======================================
unsigned long lastGetI2CSensorTime = 0;
//======================================

void setup() 
{
  Serial.begin(115200);
  // Wait MEGA32U4 USB Serial Complete
  while(!Serial);
  Serial.println();
  Serial.println("BME280 I2C(0x76) Test");
  
  bme280_status = bme280.begin(0x76);
  if(!bme280_status)
  {
    Serial.println("Initial BME280...Error");
    while(1);
  }
  Serial.println("Initial BME280...Complete");
  Serial.println();
}
 
void loop() 
{ 
  //====================================
  // Start of Read I2C Sensor(BME280)
  //====================================
  if(millis() - lastGetI2CSensorTime > 5000ul)                        // 5-Second
  {
    bme280_temperature  = bme280.readTemperature();                   // *C
    bme280_humidity     = bme280.readHumidity();                      // %RH
    bme280_pressure     = bme280.readPressure() / 100.0F;             // hPa 
    bme280_altitude     = bme280.readAltitude(SEALEVELPRESSURE_HPA);  // m
    //
    Serial.print("BME280 Temperature = ");
    Serial.print(bme280.readTemperature());
    Serial.println(" *C");
    
    Serial.print("BME280 Pressure = ");
    Serial.print(bme280.readPressure() / 100.0F);
    Serial.println(" hPa");
    
    Serial.print("BME280 Approx. Altitude = ");
    Serial.print(bme280.readAltitude(SEALEVELPRESSURE_HPA));
    Serial.println(" m");
    
    Serial.print("BME280 Humidity = ");
    Serial.print(bme280.readHumidity());
    Serial.println(" %");
    
    Serial.println();
    //==================================
    lastGetI2CSensorTime = millis();
    //==================================
  }
}

