/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : 1-Wire : DS18B20 
 */
 
//=================================================================================================
#include <OneWire.h>
#include <DallasTemperature.h>
//=================================================================================================
#define SerialDebug Serial                                                                        // USB Serial
//=================================================================================================
const int ONE_WIRE_BUS        =     5;
//=================================================================================================
//=================================================================================================
OneWire oneWire(ONE_WIRE_BUS);                  
DallasTemperature ds18b20(&oneWire);
//=================================================================================================
unsigned long lastGet1WireSensorTime = 0;
//=================================================================================================

void setup() 
{
  //===============================================================================================
  ds18b20.begin();                                                                                // 1-Wire : DS18B20 Sensor
  //===============================================================================================
  SerialDebug.begin(115200);         // Debug USART
  while(!SerialDebug);               // wait USB Serial Complete 
  SerialDebug.println();
  SerialDebug.println("Demo Test 1-WIRE DS18B20");
}

void loop() 
{
  //===============================================================================================
  // Start of Read 1-Wire Temperature
  //===============================================================================================
  if(millis() - lastGet1WireSensorTime > 5000ul)                                                  // 5-Second
  {
    //=============================================================================================
    ds18b20.requestTemperatures();                                                                // Send the command to get temperatures
    //=============================================================================================
    SerialDebug.print("DS18B20 Temperature = ");
    SerialDebug.println(ds18b20.getTempCByIndex(0),1);                                            // ttt.t   : Result Temperature(c)
    //=============================================================================================
    lastGet1WireSensorTime = millis();
    //=============================================================================================
  }
  //===============================================================================================
  // End of Read 1-Wire Temperature
  //===============================================================================================
}

