/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : Sensor SHT10 : ET-SHT10 WATER PROOF SENSOR 
 */

#include <Wire.h>
#include "SHT1x.h"

//=====================================
#define SHT10_SDA_PIN  2
#define SHT10_SCL_PIN  3
SHT1x SHT10(SHT10_SDA_PIN, SHT10_SCL_PIN);
//======================================
float sht10_temperature;
float sht10_humidity;
//======================================

//======================================
unsigned long lastGetI2CSensorTime = 0;
//======================================

void setup() 
{
  Serial.begin(115200);
  // Wait MEGA32U4 USB Serial Complete
  while(!Serial);
  Serial.println();
  Serial.println("SHT10...Test");
}
 
void loop() 
{ 
  //====================================
  // Start of Read I2C Sensor(BME280)
  //====================================
  if(millis() - lastGetI2CSensorTime > 5000ul)                        // 5-Second
  {
    sht10_temperature = SHT10.readTemperatureC();
    sht10_humidity = SHT10.readHumidity();

    Serial.print("SHT10 Temperature = ");
    Serial.print(sht10_temperature, 1);
    Serial.println("C");
    
    Serial.print("SHT10 Humidity = ");
    Serial.print(sht10_humidity,1);
    Serial.println("%");

    Serial.println();
    //==================================
    lastGetI2CSensorTime = millis();
    //==================================
  }
}

