/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : Internal Relay
 */

//=================================================================================================
const int INTERNAL_RELAY0_PIN =     6;
//=================================================================================================
const int INTERNAL_RELAY1_PIN =     7;
//=================================================================================================
const int InternalRelayOff    =     HIGH;
const int InternalRelayOn     =     LOW;
//=================================================================================================

//=================================================================================================
const int LED_LINK_PIN        =     13;
const int LED_OFF             =     LOW;
const int LED_ON              =     HIGH;
//=================================================================================================

void setup() 
{
  //===============================================================================================
  pinMode(INTERNAL_RELAY0_PIN, OUTPUT);
  digitalWrite(INTERNAL_RELAY0_PIN, InternalRelayOff);
  pinMode(INTERNAL_RELAY1_PIN, OUTPUT);
  digitalWrite(INTERNAL_RELAY1_PIN, InternalRelayOff);
  //===============================================================================================
  pinMode(LED_LINK_PIN, OUTPUT);
  digitalWrite(LED_LINK_PIN, LED_OFF);
  //===============================================================================================
}

void loop() 
{
  digitalWrite(LED_LINK_PIN, LED_ON);
  digitalWrite(INTERNAL_RELAY0_PIN, InternalRelayOn);
  digitalWrite(INTERNAL_RELAY1_PIN, InternalRelayOff); 
  delay(1000);
  
  digitalWrite(LED_LINK_PIN, LED_OFF);
  digitalWrite(INTERNAL_RELAY0_PIN, InternalRelayOff);
  digitalWrite(INTERNAL_RELAY1_PIN, InternalRelayOn); 
  delay(1000);
}


