/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : I2C : OLED 1.3 I2C
 */
 
//=================================================================================================
#include "U8glib.h"
//=================================================================================================

// setup u8g object, please remove comment from one of the following constructor calls
// IMPORTANT NOTE: The following list is incomplete. The complete list of supported 
// devices with all constructor calls is here: https://github.com/olikraus/u8glib/wiki/device

//U8GLIB_SH1106_128X64 u8g(13, 11, 10, 9);  // SW SPI Com: SCK = 13, MOSI = 11, CS = 10, A0 = 9
//U8GLIB_SH1106_128X64 u8g(4, 5, 6, 7); // SW SPI Com: SCK = 4, MOSI = 5, CS = 6, A0 = 7 (new blue HalTec OLED)
U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_NONE); // I2C / TWI 
//U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_DEV_0|U8G_I2C_OPT_FAST); // Dev 0, Fast I2C / TWI
//U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_NO_ACK); // Display which does not send ACK

const unsigned char ETT_logo [] PROGMEM = 
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xEF, 0xFB, 0xFE,
  0x20, 0x00, 0x00, 0x00, 0x27, 0xEF, 0x7B, 0xDE, 0x28, 0x01, 0x40, 0x50, 0x28, 0x01, 0x40, 0x50,
  0x28, 0x01, 0x40, 0x50, 0x2F, 0xE1, 0x40, 0x50, 0x20, 0x01, 0x40, 0x50, 0x2F, 0xE1, 0x40, 0x50,
  0x28, 0x01, 0x40, 0x50, 0x28, 0x01, 0x40, 0x50, 0x28, 0x01, 0x40, 0x50, 0x27, 0xE1, 0x40, 0x50,
  0x20, 0x01, 0x40, 0x50, 0x1F, 0xE1, 0x40, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

void draw(void) 
{
  // graphic commands to redraw the complete screen should be placed here  
  u8g.drawBitmapP( 0, 0, 4, 20, ETT_logo);
  
  u8g.setFont(u8g_font_6x10);

  u8g.drawStr( 40, 10, "OLED 1.3");
  u8g.drawStr( 40, 20, "I2C");
  
  u8g.drawStr( 0, 30, "WWW.ETTEAM.COM");
  u8g.drawStr( 0, 40, "FACEBOOK : ETTEAM");
  u8g.drawStr( 0, 50, "LINE ID  : ETTEAM1");
  u8g.drawStr( 0, 60, "LINE @   : ETTEAM");
}


void setup() 
{
  // flip screen, if required
  // u8g.setRot180();
}

void loop() 
{
  // picture loop
  u8g.firstPage();  
  do 
  {
    draw();
  } while( u8g.nextPage() );
  
  // rebuild the picture after some delay
  // delay(50);
}

