/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : Read OPTO-Input -> Write RELAY Output
 *        : External OPTO-DC Input : ET-I2C-DCIN8 
 *        : External RELAY Output  : ET-I2C-REL8
 */

#include <Wire.h>                    // I2C Bus
#include "pcf8574.h"                 // PCF8574/A
//
#define SerialDebug Serial                                                                        // USB Serial
//
//===================================================================
#define SDA_I2C         D2           // PD1
#define SCL_I2C         D3           // PD0
//===================================================================

//===================================================================
PCF8574 PCF8574A_INPUT_EXP0(0x38);   // PCF8574A = 0111,000+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP1(0x39);   // PCF8574A = 0111,001+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP2(0x3A);   // PCF8574A = 0111,010+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP3(0x3B);   // PCF8574A = 0111,011+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP4(0x3C);   // PCF8574A = 0111,100+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP5(0x3D);   // PCF8574A = 0111,101+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP6(0x3E);   // PCF8574A = 0111,110+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP7(0x3F);   // PCF8574A = 0111,111+(0:W,1:R)
//===================================================================

//===================================================================
PCF8574 PCF8574_RELAY_EXP0(0x20);    // PCF8574  = 0100,000+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP1(0x21);    // PCF8574  = 0100,001+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP2(0x22);    // PCF8574  = 0100,010+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP3(0x23);    // PCF8574  = 0100,011+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP4(0x24);    // PCF8574  = 0100,100+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP5(0x25);    // PCF8574  = 0100,101+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP6(0x26);    // PCF8574  = 0100,110+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP7(0x27);    // PCF8574  = 0100,111+(0:W,1:R)
//===================================================================

//===================================================================
byte relay_external_dev0    = 0xFF;
//===================================================================
const byte RELAY0_ON_MASK   = 0xFE;  // 1111 1110
const byte RELAY1_ON_MASK   = 0xFD;  // 1111 1101
const byte RELAY2_ON_MASK   = 0xFB;  // 1111 1011
const byte RELAY3_ON_MASK   = 0xF7;  // 1111 0111
const byte RELAY4_ON_MASK   = 0xEF;  // 1110 1111
const byte RELAY5_ON_MASK   = 0xDF;  // 1101 1111
const byte RELAY6_ON_MASK   = 0xBF;  // 1011 1111
const byte RELAY7_ON_MASK   = 0x7F;  // 0111 1111
//===================================================================
const byte RELAY0_OFF_MASK  = 0x01;  // 0000 0001
const byte RELAY1_OFF_MASK  = 0x02;  // 0000 0010
const byte RELAY2_OFF_MASK  = 0x04;  // 0000 0100
const byte RELAY3_OFF_MASK  = 0x08;  // 0000 1000
const byte RELAY4_OFF_MASK  = 0x10;  // 0001 0000
const byte RELAY5_OFF_MASK  = 0x20;  // 0010 0000
const byte RELAY6_OFF_MASK  = 0x40;  // 0100 0000
const byte RELAY7_OFF_MASK  = 0x80;  // 1000 0000
//===================================================================
uint8_t this_input0;
uint8_t last_input0;
uint8_t this_input1;
uint8_t last_input1;
uint8_t this_input2;
uint8_t last_input2;
uint8_t this_input3;
uint8_t last_input3;
uint8_t this_input4;
uint8_t last_input4;
uint8_t this_input5;
uint8_t last_input5;
uint8_t this_input6;
uint8_t last_input6;
uint8_t this_input7;
uint8_t last_input7;
//=================================================================

void setup() 
{
  //=================================================================
  Wire.begin();                      // Initial I2C Bus
  //=================================================================
  PCF8574A_INPUT_EXP0.write8(0xFF);   
  PCF8574A_INPUT_EXP1.write8(0xFF);  
  PCF8574A_INPUT_EXP2.write8(0xFF);  
  PCF8574A_INPUT_EXP3.write8(0xFF);  
  PCF8574A_INPUT_EXP4.write8(0xFF);  
  PCF8574A_INPUT_EXP5.write8(0xFF);  
  PCF8574A_INPUT_EXP6.write8(0xFF);  
  PCF8574A_INPUT_EXP7.write8(0xFF);  
  //=================================================================
  last_input0 = 0xFF;
  last_input1 = 0xFF;
  last_input2 = 0xFF;
  last_input3 = 0xFF;
  last_input4 = 0xFF;
  last_input5 = 0xFF;
  last_input6 = 0xFF;
  last_input7 = 0xFF;
  //=================================================================
  PCF8574_RELAY_EXP0.write8(last_input0);   
  PCF8574_RELAY_EXP1.write8(last_input1); 
  PCF8574_RELAY_EXP2.write8(last_input2); 
  PCF8574_RELAY_EXP3.write8(last_input3); 
  PCF8574_RELAY_EXP4.write8(last_input4); 
  PCF8574_RELAY_EXP5.write8(last_input5); 
  PCF8574_RELAY_EXP6.write8(last_input6); 
  PCF8574_RELAY_EXP7.write8(last_input7); 
  //=================================================================
}

void loop() 
{
  this_input0 = PCF8574A_INPUT_EXP0.read8(); 
  if(this_input0 != last_input0)
  {
    last_input0 = this_input0;
    PCF8574_RELAY_EXP0.write8(last_input0); 
  }
  
  this_input1 = PCF8574A_INPUT_EXP1.read8(); 
  if(this_input1 != last_input1)
  {
    last_input1 = this_input1;
    PCF8574_RELAY_EXP1.write8(last_input1); 
  }

  this_input2 = PCF8574A_INPUT_EXP2.read8(); 
  if(this_input2 != last_input2)
  {
    last_input2 = this_input2;
    PCF8574_RELAY_EXP2.write8(last_input2); 
  }

  this_input3 = PCF8574A_INPUT_EXP3.read8(); 
  if(this_input3 != last_input3)
  {
    last_input3 = this_input3;
    PCF8574_RELAY_EXP3.write8(last_input3); 
  }

  this_input4 = PCF8574A_INPUT_EXP4.read8(); 
  if(this_input4 != last_input4)
  {
    last_input4 = this_input4;
    PCF8574_RELAY_EXP4.write8(last_input4); 
  }

  this_input5 = PCF8574A_INPUT_EXP5.read8(); 
  if(this_input5 != last_input5)
  {
    last_input5 = this_input5;
    PCF8574_RELAY_EXP5.write8(last_input5); 
  }

  this_input6 = PCF8574A_INPUT_EXP6.read8(); 
  if(this_input6 != last_input6)
  {
    last_input6 = this_input6;
    PCF8574_RELAY_EXP6.write8(last_input6); 
  }

  this_input7 = PCF8574A_INPUT_EXP7.read8(); 
  if(this_input7 != last_input7)
  {
    last_input7 = this_input7;
    PCF8574_RELAY_EXP7.write8(last_input7); 
  }
}

