/*
 * Examples  : Arduino Examples By....ETT CO.,LTD
 * Program   : PCA9698_IN
 * Software  : Arduino 1.8.4
 * Hardware  : ET-BASE AVR EASY328 + ET-I2C TO 40 IO-DIN
 * Function  : Test input PCA9698 and display to serial monitor
 */
 
#include "Wire.h"
#define ADDR  0x40 >> 1     // Address for PCA9698 (AD2=VSS,AD1=VSS,AD0=VSS)

byte dataP0;
byte dataP1;
byte dataP2;
byte dataP3;
byte dataP4;

void setup() 
{
  Serial.begin(9600);      // Initialize serial communications at 9600 bps
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  
  Wire.begin();            // Initial I2C Bus

// Set up ports 0-4 
  Wire.beginTransmission(ADDR);
  Wire.write(0x98);        // Auto-Increment flag is set (AI = 1)  and  I/0 Configuration register bank 0 (0x18),Command register=10011000(0x98)
  Wire.write(0xFF);        // PORT 0 for input
  Wire.write(0xFF);        // PORT 1 for input
  Wire.write(0xFF);        // PORT 2 for input
  Wire.write(0xFF);        // PORT 3 for input
  Wire.write(0xFF);        // PORT 4 for input
  Wire.endTransmission();

  Serial.println("Demo PCA9698 Input Mode");
}

void loop() 
{
  dataP0=ReadP0();          // Read PORT 0
  dataP1=ReadP1();          // Read PORT 1
  dataP2=ReadP2();          // Read PORT 2
  dataP3=ReadP3();          // Read PORT 3
  dataP4=ReadP4();          // Read PORT 4
  
  Serial.print("P0=");
  Serial.print(dataP0,HEX);

  Serial.print("  P1=");
  Serial.print(dataP1,HEX);

  Serial.print("  P2=");
  Serial.print(dataP2,HEX);

  Serial.print("  P3=");
  Serial.print(dataP3,HEX);

  Serial.print("  P4=");
  Serial.println(dataP4,HEX);

  delay(200);
}

// Read data from PORT 0
byte ReadP0()
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x00);         // Input Port register bank 0
  Wire.endTransmission();

  Wire.requestFrom(ADDR,1); // 1 Byte Read 
  return(Wire.read());
}

// Read data from PORT 1
byte ReadP1()
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x01);         // Input Port register bank 1
  Wire.endTransmission();

  Wire.requestFrom(ADDR,1); // 1 Byte Read 
  return(Wire.read());
}

// Read data from PORT 2
byte ReadP2()
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x02);         // Input Port register bank 2
  Wire.endTransmission();

  Wire.requestFrom(ADDR,1); // 1 Byte Read 
  return(Wire.read());
}

// Read data from PORT 3
byte ReadP3()
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x03);         // Input Port register bank 3
  Wire.endTransmission();

  Wire.requestFrom(ADDR,1); // 1 Byte Read 
  return(Wire.read());
}

// Read data from PORT 1
byte ReadP4()
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x04);         // Input Port register bank 4
  Wire.endTransmission();

  Wire.requestFrom(ADDR,1); // 1 Byte Read 
  return(Wire.read());
}





