/*
 * Demo ET-ESP8266-RS485 Hardware Board
 * MCU    : ESP8266(ESP-WROOM-02)
 *        : Arduino NodeMCU
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D0:LOW=Receive,HIGH=Send)
 * I2C#1  : SCL1=D1,SDA1=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * I2C#2  : SCL2=D4,SDA2=D5
 *        : SHT10
 * ADC    : Analog#0(0.3V) 
 * Output : Wifi LED(D6:HIGH=ON,LOW=OFF)
 *        : Link LED(D7:HIGH=ON,LOW=OFF)
 *        : Relay0(LOW=ON,HIGH=OGFF)
 * 
 * Demo   : External OPTO-DC Input : ET-I2C-DCIN8 
 * 
 */
 
#include <Wire.h>                    // I2C Bus
#include "pcf8574.h"                 // PCF8574/A
//
#define SerialDebug Serial                                                                        // USB Serial
//
//===================================================================================================================
// Start of Default Hardware : ET-ESP8266-RS485
//===================================================================================================================
#define RS485_DIRECTION_PIN D0                                                                                    // ESP-WROOM-02 :D0,ESP8266:GPIO16
#define RS485_RXD_SELECT    LOW
#define RS485_TXD_SELECT    HIGH
//===================================================================================================================
#define I2C_SCL1_PIN        D1                                                                                    // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define I2C_SDA1_PIN        D2                                                                                    // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
#define BME280_SCL1_PIN     D1                                                                                    // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define BME280_SDA1_PIN     D2                                                                                    // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
#define SHT10_SCL1_PIN      D1                                                                                    // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define SHT10_SDA1_PIN      D2                                                                                    // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
//===================================================================================================================
#define RESERVE1            D3                                                                                    // ESP-WROOM-02 : D3, ESP8266 : GPIO0  (***BOOT***)
//===================================================================================================================
#define SHT10_SCL2_PIN      D4                                                                                    // ESP-WROOM-02 : D4, ESP8266 : GPIO2
#define SHT10_SDA2_PIN      D5                                                                                    // ESP-WROOM-02 : D5, ESP8266 : GPIO14 (SCK)
//===================================================================================================================
#define LED_WIFI_PIN        D6                                                                                    // ESP-WROOM-02 : D6, ESP8266 : GPIO12 (MISO)
#define WifiConnect         1
#define WifiDisconnect      0
//===================================================================================================================
#define LED_LINK_PIN        D7                                                                                    // ESP-WROOM-02 : D7, ESP8266 : GPIO13 (MOSI)
#define LedON               1
#define LedOFF              0
//===================================================================================================================
#define INTERNAL_RELAY_PIN  D8                                                                                    // ESP-WROOM-02 : D8, ESP8266 : GPIO15 (SS#)
#define InternalRelayOn     1
#define InternalRelayOff    0
//===================================================================================================================
// End of Default Hardware : ET-ESP8266-RS485
//===================================================================================================================

//===================================================================
PCF8574 PCF8574A_INPUT_EXP0(0x38);   // PCF8574A = 0111,000+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP1(0x39);   // PCF8574A = 0111,001+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP2(0x3A);   // PCF8574A = 0111,010+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP3(0x3B);   // PCF8574A = 0111,011+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP4(0x3C);   // PCF8574A = 0111,100+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP5(0x3D);   // PCF8574A = 0111,101+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP6(0x3E);   // PCF8574A = 0111,110+(0:W,1:R)
//===================================================================
PCF8574 PCF8574A_INPUT_EXP7(0x3F);   // PCF8574A = 0111,111+(0:W,1:R)
//===================================================================

uint8_t this_input;
uint8_t last_input;

void setup() 
{
  //===============================================================================================
  // Start of Initial Default Hardware : ET-ESP8266-RS485
  //===============================================================================================
  pinMode(INTERNAL_RELAY_PIN, OUTPUT);
  digitalWrite(INTERNAL_RELAY_PIN, InternalRelayOff);
  //===============================================================================================
  pinMode(LED_LINK_PIN, OUTPUT);
  digitalWrite(LED_LINK_PIN, LedOFF);
  //===============================================================================================
  pinMode(LED_WIFI_PIN, OUTPUT);
  digitalWrite(LED_WIFI_PIN, LedOFF);
  //===============================================================================================
  pinMode(RS485_DIRECTION_PIN, OUTPUT);
  digitalWrite(RS485_DIRECTION_PIN, RS485_RXD_SELECT);
  //===============================================================================================
  Wire.begin(I2C_SDA1_PIN,I2C_SCL1_PIN);                                        
  //===============================================================================================
  Serial.begin(115200);
  //===============================================================================================
  // End of Initial Default Hardware : ET-ESP8266-RS485
  //===============================================================================================
  
  PCF8574A_INPUT_EXP0.write8(0xFF);   
  last_input = 0xFF;
  //=================================================================
  SerialDebug.begin(115200);         // Debug USART
  SerialDebug.println();
  SerialDebug.println("Demo Test ET-I2C DCIN8");
}

void loop() 
{
  this_input = PCF8574A_INPUT_EXP0.read8(); 
  if(this_input != last_input)
  {
    last_input = this_input;
    SerialDebug.print("Input = ");
    if(this_input == B01111111)
    SerialDebug.print("0");                 // 1111111 -> 01111111
    SerialDebug.println(this_input,BIN);    
  }
  delay(100);
}

