/*
 * Demo ET-ESP8266-RS485 Hardware Board
 * MCU    : ESP8266(ESP-WROOM-02)
 *        : Arduino NodeMCU
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D0:LOW=Receive,HIGH=Send)
 * I2C#1  : SCL1=D1,SDA1=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * I2C#2  : SCL2=D4,SDA2=D5
 *        : SHT10
 * ADC    : Analog#0(0.3V) 
 * Output : Wifi LED(D6:HIGH=ON,LOW=OFF)
 *        : Link LED(D7:HIGH=ON,LOW=OFF)
 *        : Relay0(LOW=ON,HIGH=OGFF)
 * 
 * Demo   : SHT10 Interface on I2C BUS#2
 * 
 */

#include <Wire.h>
#include "SHT1x.h"

//===================================================================================================================
// Start of Default Hardware : ET-ESP8266-RS485
//===================================================================================================================
#define RS485_DIRECTION_PIN D0                                                                                    // ESP-WROOM-02 :D0,ESP8266:GPIO16
#define RS485_RXD_SELECT    LOW
#define RS485_TXD_SELECT    HIGH
//===================================================================================================================
#define I2C_SCL1_PIN        D1                                                                                    // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define I2C_SDA1_PIN        D2                                                                                    // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
#define BME280_SCL1_PIN     D1                                                                                    // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define BME280_SDA1_PIN     D2                                                                                    // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
#define SHT10_SCL1_PIN      D1                                                                                    // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define SHT10_SDA1_PIN      D2                                                                                    // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
//===================================================================================================================
#define RESERVE1            D3                                                                                    // ESP-WROOM-02 : D3, ESP8266 : GPIO0  (***BOOT***)
//===================================================================================================================
#define SHT10_SCL2_PIN      D4                                                                                    // ESP-WROOM-02 : D4, ESP8266 : GPIO2
#define SHT10_SDA2_PIN      D5                                                                                    // ESP-WROOM-02 : D5, ESP8266 : GPIO14 (SCK)
//===================================================================================================================
#define LED_WIFI_PIN        D6                                                                                    // ESP-WROOM-02 : D6, ESP8266 : GPIO12 (MISO)
#define WifiConnect         1
#define WifiDisconnect      0
//===================================================================================================================
#define LED_LINK_PIN        D7                                                                                    // ESP-WROOM-02 : D7, ESP8266 : GPIO13 (MOSI)
#define LedON               1
#define LedOFF              0
//===================================================================================================================
#define INTERNAL_RELAY_PIN  D8                                                                                    // ESP-WROOM-02 : D8, ESP8266 : GPIO15 (SS#)
#define InternalRelayOn     1
#define InternalRelayOff    0
//===================================================================================================================
// End of Default Hardware : ET-ESP8266-RS485
//===================================================================================================================

//=====================================
SHT1x SHT10_BUS2(SHT10_SDA2_PIN, SHT10_SCL2_PIN);
//======================================
float sht10_bus2_temperature;
float sht10_bus2_humidity;
//======================================

//======================================
unsigned long lastGetI2CSensorTime = 0;
//======================================

void setup() 
{
  //===============================================================================================
  // Start of Initial Default Hardware : ET-ESP8266-RS485
  //===============================================================================================
  pinMode(INTERNAL_RELAY_PIN, OUTPUT);
  digitalWrite(INTERNAL_RELAY_PIN, InternalRelayOff);
  //===============================================================================================
  pinMode(LED_LINK_PIN, OUTPUT);
  digitalWrite(LED_LINK_PIN, LedOFF);
  //===============================================================================================
  pinMode(LED_WIFI_PIN, OUTPUT);
  digitalWrite(LED_WIFI_PIN, LedOFF);
  //===============================================================================================
  pinMode(RS485_DIRECTION_PIN, OUTPUT);
  digitalWrite(RS485_DIRECTION_PIN, RS485_RXD_SELECT);
  //===============================================================================================
  Wire.begin(I2C_SDA1_PIN,I2C_SCL1_PIN);                                        
  //===============================================================================================
  Serial.begin(115200);
  //===============================================================================================
  // End of Initial Default Hardware : ET-ESP8266-RS485
  //===============================================================================================
  
  Serial.println();
  Serial.println("SHT10...Test");
}
 
void loop() 
{ 
  //====================================
  // Start of Read I2C Sensor(BME280)
  //====================================
  if(millis() - lastGetI2CSensorTime > 5000ul)                        // 5-Second
  {
    sht10_bus2_temperature = SHT10_BUS2.readTemperatureC();
    sht10_bus2_humidity = SHT10_BUS2.readHumidity();

    Serial.print("SHT10 Temperature = ");
    Serial.print(sht10_bus2_temperature, 1);
    Serial.println("C");
    
    Serial.print("SHT10 Humidity = ");
    Serial.print(sht10_bus2_humidity,1);
    Serial.println("%");

    Serial.println();
    //==================================
    lastGetI2CSensorTime = millis();
    //==================================
  }
}

