/*
 * Demo ET-ESP8266-RS485 Hardware Board
 * MCU    : ESP8266(ESP-WROOM-02)
 *        : Arduino NodeMCU
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D0:LOW=Receive,HIGH=Send)
 * I2C#1  : SCL1=D1,SDA1=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * I2C#2  : SCL2=D4,SDA2=D5
 *        : SHT10
 * ADC    : Analog#0(0.3V) 
 * Output : Wifi LED(D6:HIGH=ON,LOW=OFF)
 *        : Link LED(D7:HIGH=ON,LOW=OFF)
 *        : Relay0(LOW=ON,HIGH=OGFF)
 * 
 * Demo   : External Output Relay : ET-I2C-REL8 
 * 
 */
 
#include <Wire.h>                    // I2C Bus
#include "pcf8574.h"                 // PCF8574/A
//
//===================================================================================================================
// Start of Default Hardware : ET-ESP8266-RS485
//===================================================================================================================
#define RS485_DIRECTION_PIN D0                                                                                    // ESP-WROOM-02 :D0,ESP8266:GPIO16
#define RS485_RXD_SELECT    LOW
#define RS485_TXD_SELECT    HIGH
//===================================================================================================================
#define I2C_SCL1_PIN        D1                                                                                    // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define I2C_SDA1_PIN        D2                                                                                    // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
#define BME280_SCL1_PIN     D1                                                                                    // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define BME280_SDA1_PIN     D2                                                                                    // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
#define SHT10_SCL1_PIN      D1                                                                                    // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define SHT10_SDA1_PIN      D2                                                                                    // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
//===================================================================================================================
#define RESERVE1            D3                                                                                    // ESP-WROOM-02 : D3, ESP8266 : GPIO0  (***BOOT***)
//===================================================================================================================
#define SHT10_SCL2_PIN      D4                                                                                    // ESP-WROOM-02 : D4, ESP8266 : GPIO2
#define SHT10_SDA2_PIN      D5                                                                                    // ESP-WROOM-02 : D5, ESP8266 : GPIO14 (SCK)
//===================================================================================================================
#define LED_WIFI_PIN        D6                                                                                    // ESP-WROOM-02 : D6, ESP8266 : GPIO12 (MISO)
#define WifiConnect         1
#define WifiDisconnect      0
//===================================================================================================================
#define LED_LINK_PIN        D7                                                                                    // ESP-WROOM-02 : D7, ESP8266 : GPIO13 (MOSI)
#define LedON               1
#define LedOFF              0
//===================================================================================================================
#define INTERNAL_RELAY_PIN  D8                                                                                    // ESP-WROOM-02 : D8, ESP8266 : GPIO15 (SS#)
#define InternalRelayOn     1
#define InternalRelayOff    0
//===================================================================================================================
// End of Default Hardware : ET-ESP8266-RS485
//===================================================================================================================

//===================================================================
PCF8574 PCF8574_RELAY_EXP0(0x20);    // PCF8574  = 0100,000+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP1(0x21);    // PCF8574  = 0100,001+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP2(0x22);    // PCF8574  = 0100,010+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP3(0x23);    // PCF8574  = 0100,011+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP4(0x24);    // PCF8574  = 0100,100+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP5(0x25);    // PCF8574  = 0100,101+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP6(0x26);    // PCF8574  = 0100,110+(0:W,1:R)
//===================================================================
PCF8574 PCF8574_RELAY_EXP7(0x27);    // PCF8574  = 0100,111+(0:W,1:R)
//===================================================================

//===================================================================
byte relay_external_dev0    = 0xFF;
byte relay_external_dev1    = 0xFF;
byte relay_external_dev2    = 0xFF;
byte relay_external_dev3    = 0xFF;
byte relay_external_dev4    = 0xFF;
byte relay_external_dev5    = 0xFF;
byte relay_external_dev6    = 0xFF;
byte relay_external_dev7    = 0xFF;
//===================================================================
const byte RELAY0_ON_MASK   = 0xFE;  // 1111 1110
const byte RELAY1_ON_MASK   = 0xFD;  // 1111 1101
const byte RELAY2_ON_MASK   = 0xFB;  // 1111 1011
const byte RELAY3_ON_MASK   = 0xF7;  // 1111 0111
const byte RELAY4_ON_MASK   = 0xEF;  // 1110 1111
const byte RELAY5_ON_MASK   = 0xDF;  // 1101 1111
const byte RELAY6_ON_MASK   = 0xBF;  // 1011 1111
const byte RELAY7_ON_MASK   = 0x7F;  // 0111 1111
//===================================================================
const byte RELAY0_OFF_MASK  = 0x01;  // 0000 0001
const byte RELAY1_OFF_MASK  = 0x02;  // 0000 0010
const byte RELAY2_OFF_MASK  = 0x04;  // 0000 0100
const byte RELAY3_OFF_MASK  = 0x08;  // 0000 1000
const byte RELAY4_OFF_MASK  = 0x10;  // 0001 0000
const byte RELAY5_OFF_MASK  = 0x20;  // 0010 0000
const byte RELAY6_OFF_MASK  = 0x40;  // 0100 0000
const byte RELAY7_OFF_MASK  = 0x80;  // 1000 0000
//===================================================================

void setup() 
{
  //===============================================================================================
  // Start of Initial Default Hardware : ET-ESP8266-RS485
  //===============================================================================================
  pinMode(INTERNAL_RELAY_PIN, OUTPUT);
  digitalWrite(INTERNAL_RELAY_PIN, InternalRelayOff);
  //===============================================================================================
  pinMode(LED_LINK_PIN, OUTPUT);
  digitalWrite(LED_LINK_PIN, LedOFF);
  //===============================================================================================
  pinMode(LED_WIFI_PIN, OUTPUT);
  digitalWrite(LED_WIFI_PIN, LedOFF);
  //===============================================================================================
  pinMode(RS485_DIRECTION_PIN, OUTPUT);
  digitalWrite(RS485_DIRECTION_PIN, RS485_RXD_SELECT);
  //===============================================================================================
  Wire.begin(I2C_SDA1_PIN,I2C_SCL1_PIN);                                        
  //===============================================================================================
  Serial.begin(115200);
  //===============================================================================================
  // End of Initial Default Hardware : ET-ESP8266-RS485
  //===============================================================================================
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);   
  PCF8574_RELAY_EXP1.write8(relay_external_dev1); 
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);   
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);   
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);   
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);   
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);   
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);     
  //===============================================================================================
}

void loop() 
{
  relay_external_dev0 &= RELAY0_ON_MASK;
  relay_external_dev1 &= RELAY0_ON_MASK;
  relay_external_dev2 &= RELAY0_ON_MASK;
  relay_external_dev3 &= RELAY0_ON_MASK;
  relay_external_dev4 &= RELAY0_ON_MASK;
  relay_external_dev5 &= RELAY0_ON_MASK;
  relay_external_dev6 &= RELAY0_ON_MASK;
  relay_external_dev7 &= RELAY0_ON_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 |= RELAY0_OFF_MASK;
  relay_external_dev1 |= RELAY0_OFF_MASK;
  relay_external_dev2 |= RELAY0_OFF_MASK;
  relay_external_dev3 |= RELAY0_OFF_MASK;
  relay_external_dev4 |= RELAY0_OFF_MASK;
  relay_external_dev5 |= RELAY0_OFF_MASK;
  relay_external_dev6 |= RELAY0_OFF_MASK;
  relay_external_dev7 |= RELAY0_OFF_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 &= RELAY1_ON_MASK;
  relay_external_dev1 &= RELAY1_ON_MASK;
  relay_external_dev2 &= RELAY1_ON_MASK;
  relay_external_dev3 &= RELAY1_ON_MASK;
  relay_external_dev4 &= RELAY1_ON_MASK;
  relay_external_dev5 &= RELAY1_ON_MASK;
  relay_external_dev6 &= RELAY1_ON_MASK;
  relay_external_dev7 &= RELAY1_ON_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 |= RELAY1_OFF_MASK;
  relay_external_dev1 |= RELAY1_OFF_MASK;
  relay_external_dev2 |= RELAY1_OFF_MASK;
  relay_external_dev3 |= RELAY1_OFF_MASK;
  relay_external_dev4 |= RELAY1_OFF_MASK;
  relay_external_dev5 |= RELAY1_OFF_MASK;
  relay_external_dev6 |= RELAY1_OFF_MASK;
  relay_external_dev7 |= RELAY1_OFF_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 &= RELAY2_ON_MASK;
  relay_external_dev1 &= RELAY2_ON_MASK;
  relay_external_dev2 &= RELAY2_ON_MASK;
  relay_external_dev3 &= RELAY2_ON_MASK;
  relay_external_dev4 &= RELAY2_ON_MASK;
  relay_external_dev5 &= RELAY2_ON_MASK;
  relay_external_dev6 &= RELAY2_ON_MASK;
  relay_external_dev7 &= RELAY2_ON_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 |= RELAY2_OFF_MASK;
  relay_external_dev1 |= RELAY2_OFF_MASK;
  relay_external_dev2 |= RELAY2_OFF_MASK;
  relay_external_dev3 |= RELAY2_OFF_MASK;
  relay_external_dev4 |= RELAY2_OFF_MASK;
  relay_external_dev5 |= RELAY2_OFF_MASK;
  relay_external_dev6 |= RELAY2_OFF_MASK;
  relay_external_dev7 |= RELAY2_OFF_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 &= RELAY3_ON_MASK;
  relay_external_dev1 &= RELAY3_ON_MASK;
  relay_external_dev2 &= RELAY3_ON_MASK;
  relay_external_dev3 &= RELAY3_ON_MASK;
  relay_external_dev4 &= RELAY3_ON_MASK;
  relay_external_dev5 &= RELAY3_ON_MASK;
  relay_external_dev6 &= RELAY3_ON_MASK;
  relay_external_dev7 &= RELAY3_ON_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 |= RELAY3_OFF_MASK;
  relay_external_dev1 |= RELAY3_OFF_MASK;
  relay_external_dev2 |= RELAY3_OFF_MASK;
  relay_external_dev3 |= RELAY3_OFF_MASK;
  relay_external_dev4 |= RELAY3_OFF_MASK;
  relay_external_dev5 |= RELAY3_OFF_MASK;
  relay_external_dev6 |= RELAY3_OFF_MASK;
  relay_external_dev7 |= RELAY3_OFF_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 &= RELAY4_ON_MASK;
  relay_external_dev1 &= RELAY4_ON_MASK;
  relay_external_dev2 &= RELAY4_ON_MASK;
  relay_external_dev3 &= RELAY4_ON_MASK;
  relay_external_dev4 &= RELAY4_ON_MASK;
  relay_external_dev5 &= RELAY4_ON_MASK;
  relay_external_dev6 &= RELAY4_ON_MASK;
  relay_external_dev7 &= RELAY4_ON_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 |= RELAY4_OFF_MASK;
  relay_external_dev1 |= RELAY4_OFF_MASK;
  relay_external_dev2 |= RELAY4_OFF_MASK;
  relay_external_dev3 |= RELAY4_OFF_MASK;
  relay_external_dev4 |= RELAY4_OFF_MASK;
  relay_external_dev5 |= RELAY4_OFF_MASK;
  relay_external_dev6 |= RELAY4_OFF_MASK;
  relay_external_dev7 |= RELAY4_OFF_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 &= RELAY5_ON_MASK;
  relay_external_dev1 &= RELAY5_ON_MASK;
  relay_external_dev2 &= RELAY5_ON_MASK;
  relay_external_dev3 &= RELAY5_ON_MASK;
  relay_external_dev4 &= RELAY5_ON_MASK;
  relay_external_dev5 &= RELAY5_ON_MASK;
  relay_external_dev6 &= RELAY5_ON_MASK;
  relay_external_dev7 &= RELAY5_ON_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 |= RELAY5_OFF_MASK;
  relay_external_dev1 |= RELAY5_OFF_MASK;
  relay_external_dev2 |= RELAY5_OFF_MASK;
  relay_external_dev3 |= RELAY5_OFF_MASK;
  relay_external_dev4 |= RELAY5_OFF_MASK;
  relay_external_dev5 |= RELAY5_OFF_MASK;
  relay_external_dev6 |= RELAY5_OFF_MASK;
  relay_external_dev7 |= RELAY5_OFF_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 &= RELAY6_ON_MASK;
  relay_external_dev1 &= RELAY6_ON_MASK;
  relay_external_dev2 &= RELAY6_ON_MASK;
  relay_external_dev3 &= RELAY6_ON_MASK;
  relay_external_dev4 &= RELAY6_ON_MASK;
  relay_external_dev5 &= RELAY6_ON_MASK;
  relay_external_dev6 &= RELAY6_ON_MASK;
  relay_external_dev7 &= RELAY6_ON_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 |= RELAY6_OFF_MASK;
  relay_external_dev1 |= RELAY6_OFF_MASK;
  relay_external_dev2 |= RELAY6_OFF_MASK;
  relay_external_dev3 |= RELAY6_OFF_MASK;
  relay_external_dev4 |= RELAY6_OFF_MASK;
  relay_external_dev5 |= RELAY6_OFF_MASK;
  relay_external_dev6 |= RELAY6_OFF_MASK;
  relay_external_dev7 |= RELAY6_OFF_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 &= RELAY7_ON_MASK;
  relay_external_dev1 &= RELAY7_ON_MASK;
  relay_external_dev2 &= RELAY7_ON_MASK;
  relay_external_dev3 &= RELAY7_ON_MASK;
  relay_external_dev4 &= RELAY7_ON_MASK;
  relay_external_dev5 &= RELAY7_ON_MASK;
  relay_external_dev6 &= RELAY7_ON_MASK;
  relay_external_dev7 &= RELAY7_ON_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
  //
  relay_external_dev0 |= RELAY7_OFF_MASK;
  relay_external_dev1 |= RELAY7_OFF_MASK;
  relay_external_dev2 |= RELAY7_OFF_MASK;
  relay_external_dev3 |= RELAY7_OFF_MASK;
  relay_external_dev4 |= RELAY7_OFF_MASK;
  relay_external_dev5 |= RELAY7_OFF_MASK;
  relay_external_dev6 |= RELAY7_OFF_MASK;
  relay_external_dev7 |= RELAY7_OFF_MASK;
  PCF8574_RELAY_EXP0.write8(relay_external_dev0);
  PCF8574_RELAY_EXP1.write8(relay_external_dev1);
  PCF8574_RELAY_EXP2.write8(relay_external_dev2);
  PCF8574_RELAY_EXP3.write8(relay_external_dev3);
  PCF8574_RELAY_EXP4.write8(relay_external_dev4);
  PCF8574_RELAY_EXP5.write8(relay_external_dev5);
  PCF8574_RELAY_EXP6.write8(relay_external_dev6);
  PCF8574_RELAY_EXP7.write8(relay_external_dev7);
  delay(500);
}

