/*******************************************/
/* Example Program For ET-BASE51 AC3 V1.0  */
/* MCU      : AT89C51AC3(XTAL=29.4912 MHz) */
/*          : Frequency Bus = 58.9824 MHz  */
/* Compiler : Keil C51 (V7.50)             */
/* Write By : Eakachai Makarn(ETT CO.,LTD.)*/
/* Examples : Demo Hardware SPI (MCP4922)  */
/*******************************************/
/*******************************************/
/* SPI Interface to ET-MINI MCP4922(DAC)   */
/* MOSI(P4.4)  --> SDI   				   */
/* MISO(P4.2)  <-- NC					   */
/* SCK(P4.3)   --> SCK      		       */
/* SS#(P3.5)   --> NC                      */
/* P4.0        --> LDAC#             	   */
/* P4.1        --> CS#                     */
/*******************************************/
// Demo SPI + ET-MINI MCP4922(12Bit SPI DAC)

/* Include  Section */
#include <reg52.h>														// Standard 8052 SFR : File

/* AT89C51AC3 SFR */
sfr CKCON = 0x8F;														// Clock Control
sfr SPCR  = 0xD4;														// SPI Config
sfr SPSR  = 0xD5;														// SPI Status
sfr SPDR  = 0xD6;														// SPI Data
sfr P4    = 0xC0;														// Port P4

sbit MCP4922_LDAC = P4^0;												// Latch DAC Output
sbit MCP4922_CS   = P4^1;												// Chips Select DAC

/* User Define Function */
void SPI_WriteByte(unsigned char DataByte);								// Write 1-Byte to SPI
void Write_MCP4922(unsigned char DAC_Channel,unsigned int DAC_Data);	// Write MCP4922 Data

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main()
{  
  CKCON = 0x01;															// Initial X2 Mode (BUS Clock = 58.9824 MHz) 
 
  /* Initial SPI */
  SPCR &= 0x7F;                 										// SPIE = 0 = Disable SPI Interrupt
  SPCR &= 0xDF; 			 											// DORD = 0 = MSB First
  SPCR &= 0xF3;              											// CPOL:CPHA  = 0:0 = SCK Rising Edge Shift Data
  SPCR |= 0x03; 			 											// SPR1:SPR00 = 1:1 = SCK is Fosc/64
  SPCR |= 0x10;  														// MSTR = 1 = SPI Master Mode                    										
  SPCR |= 0x40;              											// SPE  = 1 = SPI Enable				
   
  MCP4922_LDAC = 1;  													// Prepare Start Signal
  MCP4922_CS = 1;                  										

  // Strat Write DAC Output 
  Write_MCP4922(0x00,0x7FF);	 										// DAC-A = 1/2  Scale of REF-A
  Write_MCP4922(0x01,0xFFF);	 										// DAC-B = Full	Scale of REF-B

  while(1);																// Loop Continue
}

/***********************/
/* Write 1 Byte to SPI */
/***********************/
void SPI_WriteByte(unsigned char DataByte)								// Write Byte to SPI
{
  unsigned char Dummy;

  SPDR = DataByte;														// Send Byte to SPI
  while((SPSR & 0x80)!= 0x80){;;}										// Wait SPIF = 1   
  Dummy = SPDR;															// Read For Reset SPIF	   
}

/**********************/
/* MCP4922 Write Data */
/**********************/
void Write_MCP4922(unsigned char DAC_Channel,unsigned int DAC_Data)	  	// Write DAC Output
{                                     
  MCP4922_CS = 0;                  										// Enable MCP4922 

  switch (DAC_Channel)													// Select DAC Channel(0=A,1=B)						
  {
    case 0x00: DAC_Data |= 0x3000;										// Write DAC-A
  	           break;
  	case 0x01: DAC_Data |= 0xB000;										// Write DAC-B
  	           break;
  }
  
  SPI_WriteByte((DAC_Data >> 8)& 0xFF);  								// Data Byte High
  SPI_WriteByte(DAC_Data & 0xFF);  										// Data Byte Low

  MCP4922_CS = 1;                  										// Disable MCP4922
    
  MCP4922_LDAC = 0;														// Enable Pulse Latch
  MCP4922_LDAC = 1;  	  
}   




					
					

