;/************************************/;
;/* Examples For : ET-MINI MCP4922   */;
;/* Hardware     : ET-BASE51AC3 V1   */;
;/* Controller   : AT89C51AC3        */;
;/* Run X-TAL    : 29.4912 MHz       */;
;/*              : Run X2 Mode       */;
;/* System Clock : 58.9824 MHz       */;
;/* Assembler    : SXA51.EXE         */;
;/* File Name    : SPI_DAC2.ASM      */;
;/* Function     : Demo Hardware SPI */;
;/*              : Interface MCP4922 */;
;/************************************/;
;/************************************/;
;/* AT89C51AC3 Interface MCP4922     */;
;/* -> P4.0(I/O)   --> LDAC#         */;
;/* -> P4.1(I/O)   --> CS#           */;
;/* -> P4.4(I/O)   --> SDI           */;
;/* -> P4.3(I/O)   --> SCK           */;
;/************************************/;
;
;/* AT89C51AC3 Clock Control */;
AUXR                EQU     8EH
CKCON0              EQU     8FH
CKCON1              EQU     9FH
IEN0                EQU     0A8H
;
;/* AT89C51AC3 SPI Register */;
SPCON               EQU     0D4H                            ; SPI Config
SPSCR               EQU     0D5H                            ; SPI Status
SPDAT               EQU     0D6H                            ; SPI Data
;
;/* 12 Bit DAC(MCP4922) Interface */;
P4                  EQU     0C0H                            ; AT89C51AC3 Port-P4
MCP4922_LDAC_PIN    EQU     P4.0                            ; Port I/O
MCP4922_CS_PIN      EQU     P4.1                            ; Port I/O
MCP4922_DIN_PIN     EQU     P4.4                            ; MOSI(SPI)
MCP4922_CLK_PIN     EQU     P4.3                            ; SCK(SPI)

                    ORG     20H
DAC_DATA:           DS      2                               ; DAC Output
STACK:              DS      30                              ; Stack 30 Byte

                    ORG     0000H                           ; Reset Vector of CPU
                    ;
MAIN:               MOV     SP,#STACK                       ; Initial Stack
                    MOV     CKCON0,#00000001B               ; 6 Clock Mode(X2 Mode)
                    ;
                    ;/* Initial SPI = Master Mode
                    ;/* Shift Data  = Rising Edge(MSB First)
                    ;/* SPI Clock Rate  = Fosc/64
                    ANL       SPCON,#01111111B              ; SPIE = 0 = Disable SPI Interrupt
                    ANL       SPCON,#11011111B              ; DORD = 0 = MSB First
                    ANL       SPCON,#11110011B              ; CPOL:CPHA  = 0:0 = SCK Rising Edge Shift Data
                    ORL       SPCON,#00000011B              ; SPR1:SPR00 = 1:1 = SCK is Fosc/64
                    ORL       SPCON,#00010000B              ; MSTR = 1 = SPI Master Mode
                    ORL       SPCON,#01000000B              ; SPE  = 1 = SPI Enable
                    MOV     A,SPDAT                         ; Read For Reset SPIF
                    ;
                    SETB    MCP4922_CS_PIN                  ; Disable MCP4922 Interface
                    SETB    MCP4922_LDAC_PIN                ; Disable MCP4922 Latch
                    ;
                    ;/* Start Write DAC Output */;
                    MOV     DAC_DATA+0,#0FH                 ; Full Scale of REF-A
                    MOV     DAC_DATA+1,#0FFH
                    LCALL   MCP4922_SEND_DA0                ; Send Data to DAC
                    ;
                    MOV     DAC_DATA+0,#07H                 ; 1/2 Scale of REF-B
                    MOV     DAC_DATA+1,#0FFH
                    LCALL   MCP4922_SEND_DA1                ; Send Data to DAC
                    ;
                    SJMP    $

;/***************************/;
;/* Update Output To DAC-A  */;
;/* Input : DAC_DATA+[0..1] */;
;/***************************/;
;
MCP4922_SEND_DA0:   CLR     MCP4922_CS_PIN                  ; Enable MCP4922 Interface
                    MOV     A,DAC_DATA+0                    ; Setup DAC = A
                    ORL     A,#00110000B                    ; DAC-A,Un-Buffer,Power-ON
                    LCALL   SPI_SEND_BYTE                   ; Send High Byte
                    MOV     A,DAC_DATA+1
                    LCALL   SPI_SEND_BYTE                   ; Send Low Byte
                    SETB    MCP4922_CS_PIN                  ; Disable MCP4922 Interface
                    ;
                    ;/* Latch DAC Output Signal */;
                    CLR     MCP4922_LDAC_PIN                ; Latch DAC Output
                    SETB    MCP4922_LDAC_PIN
                    RET

;/***************************/;
;/* Update Output To DAC-B  */;
;/* Input : DAC_DATA+[0..1] */;
;/***************************/;
;
MCP4922_SEND_DA1:   CLR     MCP4922_CS_PIN                  ; Enable MCP4922 Interface
                    MOV     A,DAC_DATA+0                    ; Setup DAC = B
                    ORL     A,#10110000B                    ; DAC-B,Un-Buffer,Power-ON
                    LCALL   SPI_SEND_BYTE                   ; Send High Byte
                    MOV     A,DAC_DATA+1
                    LCALL   SPI_SEND_BYTE                   ; Send Low Byte
                    SETB    MCP4922_CS_PIN                  ; Disable MCP4922 Interface
                    ;
                    ;/* Latch DAC Output Signal */;
                    CLR     MCP4922_LDAC_PIN                ; Latch DAC Output
                    SETB    MCP4922_LDAC_PIN
                    RET

;/*****************/;
;/* SPI Send Byte */;
;/* Input : ACC   */;
;/*****************/;
;
SPI_SEND_BYTE:      MOV     SPDAT,A                     ; Send Data to SPI
                    ;
WAIT_SPI_SEND:      MOV     A,SPSCR                     ; Read SPI Status
                    JNB     ACC.7,WAIT_SPI_SEND         ; Wait SPIF = 1 = SPI Send Complete
                    MOV     A,SPDAT                     ; Read For Reset SPIF
                    RET

                    END




          
