/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : Test HT16K33 Control 7 Segment Display 
 */

//=========================================================================================
#include <Wire.h> 
//=========================================================================================
#include "ET_HT16K33_7SEGMENT.h"
//=========================================================================================
ET_HT16K33_7SEGMENT display0 = ET_HT16K33_7SEGMENT(0x70);
ET_HT16K33_7SEGMENT display1 = ET_HT16K33_7SEGMENT(0x71);
ET_HT16K33_7SEGMENT display2 = ET_HT16K33_7SEGMENT(0x72);
ET_HT16K33_7SEGMENT display3 = ET_HT16K33_7SEGMENT(0x73);
ET_HT16K33_7SEGMENT display4 = ET_HT16K33_7SEGMENT(0x74);
ET_HT16K33_7SEGMENT display5 = ET_HT16K33_7SEGMENT(0x71);
ET_HT16K33_7SEGMENT display6 = ET_HT16K33_7SEGMENT(0x76);
ET_HT16K33_7SEGMENT display7 = ET_HT16K33_7SEGMENT(0x77);
//=========================================================================================

void setup() 
{
  display0.begin();
  display1.begin();
  display2.begin();
  display3.begin();
  display4.begin();
  display5.begin();
  display6.begin();
  display7.begin();
}

void loop() 
{
  //=======================================================================================
  // Test Display Segment : A..G,Dp
  //=======================================================================================
  for(uint8_t seg=0; seg<8; seg++)              // Seg-A,Seg-B,Seg-C,...,Seg-G,Seg-Dp
  {
    display0.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display1.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display2.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display3.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display4.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display5.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display6.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display7.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    //
    display0.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display1.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display2.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display3.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display4.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display5.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display6.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display7.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    //
    display0.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display1.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display2.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display3.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display4.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display5.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display6.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display7.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    //
    display0.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display1.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display2.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display3.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display4.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display5.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display6.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display7.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    //=====================================================================================
    display0.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display1.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display2.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display3.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display4.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display5.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display6.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display7.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    //
    display0.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display1.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display2.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display3.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display4.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display5.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display6.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display7.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    //
    display0.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display1.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display2.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display3.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display4.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display5.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display6.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display7.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    //
    display0.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display1.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display2.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display3.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display4.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display5.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display6.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display7.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    //=====================================================================================
    delay(1000);
    //=====================================================================================
  }
  //=======================================================================================

  //=======================================================================================
  // Test Display Number : 0..9,A..F
  //=======================================================================================  
  for(uint16_t bcd=0; bcd<16; bcd++)            // 0..9,A..F
  {
    display0.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display1.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display2.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display3.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display4.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display5.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display6.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display7.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    //
    display0.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display1.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display2.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display3.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display4.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display5.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display6.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display7.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    //
    display0.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display1.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display2.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display3.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display4.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display5.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display6.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display7.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    //
    display0.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display1.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display2.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display3.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display4.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display5.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display6.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display7.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    //=====================================================================================
    display0.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display1.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display2.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display3.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display4.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display5.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display6.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display7.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    //
    display0.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display1.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display2.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display3.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display4.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display5.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display6.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display7.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    //
    display0.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display1.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display2.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display3.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display4.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display5.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display6.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display7.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    //
    display0.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display1.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display2.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display3.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display4.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display5.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display6.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display7.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    //=====================================================================================
    delay(1000);
    //=====================================================================================
  }
  //=======================================================================================

  //=======================================================================================
  // 3 Digit : [ ] [1] [2] [3]  
  // 4 Digit : [0] [1] [2] [3]  
  //=======================================================================================
  display0.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display1.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display2.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display3.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display4.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display5.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display6.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display7.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  //
  display0.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display1.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display2.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display3.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display4.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display5.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display6.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display7.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  //
  display0.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display1.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display2.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display3.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display4.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display5.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display6.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display7.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  //
  display0.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display1.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display2.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display3.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display4.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display5.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display6.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display7.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  //=======================================================================================
  display0.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display1.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display2.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display3.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display4.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display5.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display6.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display7.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  //=======================================================================================

  //=======================================================================================
  // 3 Digit : [ ] [5] [6] [7]  
  // 4 Digit : [4] [5] [6] [7]  
  //=======================================================================================
  display0.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display1.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display2.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display3.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display4.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display5.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display6.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display7.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  //
  display0.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display1.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display2.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display3.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display4.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display5.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display6.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display7.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  //
  display0.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display1.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display2.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display3.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display4.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display5.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display6.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display7.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  //
  display0.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display1.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display2.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display3.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display4.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display5.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display6.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display7.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  //=======================================================================================
  display0.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display1.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display2.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display3.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display4.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display5.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display6.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display7.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  //=======================================================================================

  //=======================================================================================
  // 4 Digit : [ ] [9] [A] [B]  
  // 4 Digit : [8] [9] [A] [B]  
  //=======================================================================================
  display0.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display1.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display2.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display3.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display4.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display5.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display6.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display7.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  //
  display0.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display1.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display2.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display3.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display4.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display5.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display6.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display7.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  //
  display0.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display1.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display2.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display3.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display4.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display5.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display6.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display7.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  //
  display0.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display1.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display2.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display3.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display4.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display5.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display6.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display7.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  //=======================================================================================
  display0.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display1.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display2.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display3.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display4.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display5.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display6.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display7.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  //=======================================================================================

  //=======================================================================================
  // 3 Digit : [ ] [D] [E] [F]  
  // 4 Digit : [C] [D] [E] [F]  
  //=======================================================================================
  display0.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display1.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display2.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display3.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display4.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display5.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display6.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display7.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  //
  display0.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display1.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display2.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display3.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display4.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display5.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display6.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display7.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  //
  display0.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display1.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display2.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display3.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display4.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display5.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display6.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display7.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  //
  display0.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display1.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display2.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display3.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display4.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display5.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display6.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display7.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  //=======================================================================================
  display0.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display1.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display2.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display3.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display4.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display5.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display6.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display7.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  //=======================================================================================
  delay(5000);
  //=======================================================================================
}

