/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : Demo HT16K33 Control 7 Segment Display SHT31 Temperature & Humidity 
 */

//=========================================================================================
#include <Wire.h> 
//=========================================================================================
#include "ET_HT16K33_7SEGMENT.h"
//=========================================================================================
#include <Adafruit_SHT31.h>
//=========================================================================================
ET_HT16K33_7SEGMENT display = ET_HT16K33_7SEGMENT(0x70);
//=========================================================================================

//=========================================================================================
Adafruit_SHT31 sht31 = Adafruit_SHT31();                                                 // I2C
//=========================================================================================
float sht31_temperature;
float sht31_humidity;
bool  sht31_status;
//=========================================================================================
unsigned long lastGetI2CSensorTime = 0;
//=========================================================================================

void setup() 
{
  //=======================================================================================
  Wire.begin();                                        
  //=======================================================================================
  Serial.begin(115200);
  //=======================================================================================
 
  //=======================================================================================
  // Initial HT16K33 Display Control
  //=======================================================================================
  display.begin();
  //=======================================================================================

  //===============================================================================================
  // Start of Initial SHT31
  //===============================================================================================
  Serial.println();
  Serial.println("SHT31 I2C(0x44) Test");
  //===============================================================================================
  sht31_status = sht31.begin(0x44);
  if(!sht31_status)
  {
    Serial.println("Initial SHT31...Error");
    display.print(10000, DEC);                        // Print Error(number too long) : [-][-][-][-]
    display.writeDisplayPanel0();                     // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display.writeDisplayPanel1();                     // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display.writeDisplayPanel2();                     // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display.writeDisplayPanel3();                     // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    while(1);
  }
  //===============================================================================================
  Serial.println("Initial SHT31...Complete");
  Serial.println();
  //===============================================================================================
  // End of Initial SHT31
  //===============================================================================================
  
}

void loop() 
{
  //=============================================================================================
  // Start of Update SHT31 Sensor Value
  //=============================================================================================
  if(millis() - lastGetI2CSensorTime > 1000ul)        // 1-Second
  {
    sht31_temperature  = sht31.readTemperature();     // *C
    sht31_humidity     = sht31.readHumidity();        // %RH
    
    if(! isnan(sht31_temperature)) 
    {
      Serial.print("SHT31 Temperature = ");
      Serial.print(sht31.readTemperature());
      Serial.println(" *C");

      display.print(sht31_temperature,1);             // Create Display Buffer = tt.t
      display.writeDisplayPanel0();                   // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
      display.writeDisplayPanel2();                   // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    }
    if(! isnan(sht31_humidity)) 
    {
      Serial.print("SHT31 Humidity = ");
      Serial.print(sht31.readHumidity());
      Serial.println(" %");

      display.print(sht31_humidity,1);                // Create Display Buffer = hh.h
      display.writeDisplayPanel1();                   // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
      display.writeDisplayPanel3();                   // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    }
    //===========================================================================================
    lastGetI2CSensorTime = millis();
    //===========================================================================================
    
  }
  //=============================================================================================
  // End of Update SHT31 Sensor Value
  //=============================================================================================
}


