/*
 * Demo ET-MEGA32U4-RS485 Hardware Board
 * MCU    : ATMEGA32U4
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : BME280
 *        : RTC:DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : I2C OLED 1.3
 * ADC    : Analog#0 : A;[0..3]
 *        : Analog#1 : A4
 *        : Analog#2 : A5
 * Output : Link(LED Active High:D13)
 *        : Relay0(Active Low:D6)
 *        : Relay1(Active Low:D7)
 * Input  : RS485 ID0:D8
 *        : RS485 ID1:D9
 *        : RS485 ID2:D10
 *        : RS485 ID3:D11
 *        : RS485 ID4:D12
 * 1-Wire : DS18B20(1-Wire:D5)
 * 
 * Demo   : Test HT16K33 Control 7 Segment Display 
 */

//=========================================================================================
#include <Wire.h> 
//=========================================================================================
#include "ET_HT16K33_7SEGMENT.h"
//=========================================================================================
ET_HT16K33_7SEGMENT display = ET_HT16K33_7SEGMENT(0x70);
//=========================================================================================

void setup() 
{
  display.begin();
}

void loop() 
{
  // try to print a number thats too long
  display.print(10000, DEC);
  display.writeDisplayPanel0();               // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display.writeDisplayPanel1();               // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display.writeDisplayPanel2();               // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display.writeDisplayPanel3();               // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  delay(5000);

  // print a hex number
  display.print(0xBEEF, HEX);
  display.writeDisplayPanel0();               // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display.writeDisplayPanel1();               // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display.writeDisplayPanel2();               // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display.writeDisplayPanel3();               // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  delay(5000);

  // print a floating point 
  display.print(12.34);
  display.writeDisplayPanel0();               // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display.writeDisplayPanel1();               // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display.writeDisplayPanel2();               // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display.writeDisplayPanel3();               // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  delay(5000);

  // print a floating point 
  display.print(123.4);
  display.writeDisplayPanel0();               // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display.writeDisplayPanel1();               // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display.writeDisplayPanel2();               // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display.writeDisplayPanel3();               // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  delay(5000);
  
  //=======================================================================================
  // Test Display Segment : A..G,Dp
  //=======================================================================================
  for(uint16_t counter = 0; counter < 9999; counter++)
  {
    //=====================================================================================
    display.println(counter);
    //=====================================================================================
    display.writeDisplayPanel0();             // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display.writeDisplayPanel1();             // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display.writeDisplayPanel2();             // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display.writeDisplayPanel3();             // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    //=====================================================================================
    delay(10);
    //=====================================================================================
  }
  //=======================================================================================

  
}


