/*
 * Demo ET-ESP8266-RS485 Hardware Board
 * MCU    : ESP8266(ESP-WROOM-02)
 *        : Arduino NodeMCU 
 * RS485  : RS485 RXD:D9
 *        : RS485 TXD:D10
 *        : RS485 Direction : D0(Low=Receive,High=Send)
 * I2C    : I2C1:SCL1=D1,SDA1=D2
 *        : I2C2:SCL2=D5,SDA2=D4
 *        : BME280
 *        : DS3231
 *        : PCF8574(External Output Relay)
 *        : PCF8574A(External Input Opto)
 *        : OLED 1.3
 * ADC    : Analog#0 : ADC(0..3V)
 * Output : WiFi(LED Active High:D6)
 *        : Link(LED Active High:D7)
 *        : Relay(Active Low:D8)
 * 
 * Demo   : Demo Test HT16K33 Control 7 Segment Display 
 */

//=========================================================================================

#include <Wire.h> 
#include "ET_HT16K33_7SEGMENT.h"

//=========================================================================================
// Start of Default Hardware : ET-ESP8266-RS485
//=========================================================================================
#define RS485_DIRECTION_PIN D0                                                             // ESP-WROOM-02 :D0,ESP8266:GPIO16
#define RS485_RXD_SELECT    LOW
#define RS485_TXD_SELECT    HIGH
//=========================================================================================
#define I2C_SCL1_PIN        D1                                                             // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define I2C_SDA1_PIN        D2                                                             // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
#define BME280_SCL1_PIN     D1                                                             // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define BME280_SDA1_PIN     D2                                                             // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
#define SHT10_SCL1_PIN      D1                                                             // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define SHT10_SDA1_PIN      D2                                                             // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
#define SHT31_SCL1_PIN      D1                                                             // ESP-WROOM-02 : D1, ESP8266 : GPIO5  (***SCL***)
#define SHT31_SDA1_PIN      D2                                                             // ESP-WROOM-02 : D2, ESP8266 : GPIO4  (***SDA***)
//=========================================================================================
#define RESERVE1            D3                                                             // ESP-WROOM-02 : D3, ESP8266 : GPIO0  (***BOOT***)
#define SWITCH_PIN          D3
#define SwitchRelease       1
#define SwitchPress         0
//=========================================================================================
#define SHT10_SCL2_PIN      D4                                                             // ESP-WROOM-02 : D4, ESP8266 : GPIO2
#define SHT10_SDA2_PIN      D5                                                             // ESP-WROOM-02 : D5, ESP8266 : GPIO14 (SCK)
//=========================================================================================
#define LED_WIFI_PIN        D6                                                             // ESP-WROOM-02 : D6, ESP8266 : GPIO12 (MISO)
#define WifiConnect         1
#define WifiDisconnect      0
//=========================================================================================
#define LED_LINK_PIN        D7                                                             // ESP-WROOM-02 : D7, ESP8266 : GPIO13 (MOSI)
#define LedOn               1
#define LedOff              0
//=========================================================================================
#define INTERNAL_RELAY_PIN  D8                                                             // ESP-WROOM-02 : D8, ESP8266 : GPIO15 (SS#)
#define InternalRelayOn     1
#define InternalRelayOff    0
//=========================================================================================
// End of Default Hardware : ET-ESP8266-RS485
//=========================================================================================

ET_HT16K33_7SEGMENT display0 = ET_HT16K33_7SEGMENT(0x70);
ET_HT16K33_7SEGMENT display1 = ET_HT16K33_7SEGMENT(0x71);
ET_HT16K33_7SEGMENT display2 = ET_HT16K33_7SEGMENT(0x72);
ET_HT16K33_7SEGMENT display3 = ET_HT16K33_7SEGMENT(0x73);
ET_HT16K33_7SEGMENT display4 = ET_HT16K33_7SEGMENT(0x74);
ET_HT16K33_7SEGMENT display5 = ET_HT16K33_7SEGMENT(0x71);
ET_HT16K33_7SEGMENT display6 = ET_HT16K33_7SEGMENT(0x76);
ET_HT16K33_7SEGMENT display7 = ET_HT16K33_7SEGMENT(0x77);

void setup() 
{
  //=======================================================================================
  // Start of Initial Default Hardware : ET-ESP8266-RS485
  //=======================================================================================
  pinMode(INTERNAL_RELAY_PIN, OUTPUT);
  digitalWrite(INTERNAL_RELAY_PIN, InternalRelayOff);
  //=======================================================================================
  pinMode(LED_LINK_PIN, OUTPUT);
  digitalWrite(LED_LINK_PIN, LedOff);
  //=======================================================================================
  pinMode(LED_WIFI_PIN, OUTPUT);
  digitalWrite(LED_WIFI_PIN, WifiDisconnect);
  //=======================================================================================
  pinMode(SWITCH_PIN, INPUT);
  //=======================================================================================
  pinMode(RS485_DIRECTION_PIN, OUTPUT);
  digitalWrite(RS485_DIRECTION_PIN, RS485_RXD_SELECT);
  //=======================================================================================
  Wire.begin(I2C_SDA1_PIN,I2C_SCL1_PIN);                                        
  //=======================================================================================
  Serial.begin(115200);
  //=======================================================================================
  // End of Initial Default Hardware : ET-ESP8266-RS485
  //=======================================================================================

  //=======================================================================================
  // Initial HT16K33 Display Control
  //=======================================================================================
  display0.begin();
  display1.begin();
  display2.begin();
  display3.begin();
  display4.begin();
  display5.begin();
  display6.begin();
  display7.begin();
  //=======================================================================================
}

void loop() 
{
  //=======================================================================================
  // Test Display Segment : A..G,Dp
  //=======================================================================================
  for(uint8_t seg=0; seg<8; seg++)              // Seg-A,Seg-B,Seg-C,...,Seg-G,Seg-Dp
  {
    display0.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display1.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display2.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display3.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display4.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display5.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display6.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    display7.writeDigitSegment(0,(1<<(seg)));   // Write Buffer Digit[0] : [x][?][?][?]
    //
    display0.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display1.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display2.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display3.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display4.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display5.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display6.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    display7.writeDigitSegment(1,(1<<(seg)));   // Write Buffer Digit[1] : [?][x][?][?]
    //
    display0.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display1.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display2.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display3.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display4.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display5.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display6.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    display7.writeDigitSegment(2,(1<<(seg)));   // Write Buffer Digit[2] : [?][?][x][?]
    //
    display0.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display1.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display2.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display3.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display4.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display5.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display6.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    display7.writeDigitSegment(3,(1<<(seg)));   // Write Buffer Digit[3] : [?][?][?][x]
    //=====================================================================================
    display0.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display1.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display2.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display3.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display4.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display5.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display6.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display7.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    //
    display0.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display1.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display2.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display3.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display4.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display5.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display6.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display7.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    //
    display0.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display1.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display2.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display3.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display4.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display5.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display6.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display7.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    //
    display0.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display1.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display2.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display3.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display4.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display5.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display6.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display7.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    //=====================================================================================
    delay(1000);
    //=====================================================================================
  }
  //=======================================================================================

  //=======================================================================================
  // Test Display Number : 0..9,A..F
  //=======================================================================================  
  for(uint16_t bcd=0; bcd<16; bcd++)            // 0..9,A..F
  {
    display0.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display1.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display2.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display3.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display4.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display5.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display6.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    display7.writeDigitBCD(0,bcd);              // Write Buffer Digit[0] : [0][?][?][?]
    //
    display0.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display1.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display2.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display3.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display4.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display5.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display6.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    display7.writeDigitBCD(1,bcd);              // Write Buffer Digit[1] : [?][1][?][?]
    //
    display0.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display1.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display2.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display3.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display4.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display5.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display6.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    display7.writeDigitBCD(2,bcd);              // Write Buffer Digit[2] : [?][?][2][?]
    //
    display0.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display1.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display2.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display3.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display4.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display5.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display6.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    display7.writeDigitBCD(3,bcd);              // Write Buffer Digit[3] : [?][?][?][3]
    //=====================================================================================
    display0.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display1.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display2.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display3.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display4.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display5.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display6.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    display7.writeDisplayPanel0();              // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
    //
    display0.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display1.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display2.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display3.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display4.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display5.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display6.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    display7.writeDisplayPanel1();              // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
    //
    display0.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display1.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display2.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display3.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display4.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display5.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display6.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    display7.writeDisplayPanel2();              // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
    //
    display0.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display1.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display2.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display3.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display4.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display5.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display6.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    display7.writeDisplayPanel3();              // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
    //=====================================================================================
    delay(1000);
    //=====================================================================================
  }
  //=======================================================================================

  //=======================================================================================
  // 3 Digit : [ ] [1] [2] [3]  
  // 4 Digit : [0] [1] [2] [3]  
  //=======================================================================================
  display0.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display1.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display2.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display3.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display4.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display5.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display6.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  display7.writeDigitBCD(0,0);                  // Write Buffer Digit[0] : [0][?][?][?]
  //
  display0.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display1.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display2.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display3.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display4.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display5.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display6.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  display7.writeDigitBCD(1,1);                  // Write Buffer Digit[1] : [?][1][?][?]
  //
  display0.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display1.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display2.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display3.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display4.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display5.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display6.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  display7.writeDigitBCD(2,2);                  // Write Buffer Digit[2] : [?][?][2][?]
  //
  display0.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display1.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display2.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display3.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display4.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display5.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display6.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  display7.writeDigitBCD(3,3);                  // Write Buffer Digit[3] : [?][?][?][3]
  //=======================================================================================
  display0.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display1.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display2.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display3.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display4.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display5.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display6.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  display7.writeDisplayPanel0();                // Transfer Buffer to Display Panel[0] & Update to HT16K33(Lower-LSB)
  //=======================================================================================

  //=======================================================================================
  // 3 Digit : [ ] [5] [6] [7]  
  // 4 Digit : [4] [5] [6] [7]  
  //=======================================================================================
  display0.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display1.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display2.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display3.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display4.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display5.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display6.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  display7.writeDigitBCD(0,4);                  // Write Buffer Digit[0] :  [0][?][?][?]
  //
  display0.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display1.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display2.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display3.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display4.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display5.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display6.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  display7.writeDigitBCD(1,5);                  // Write Buffer Digit[1] : [?][1][?][?]
  //
  display0.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display1.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display2.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display3.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display4.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display5.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display6.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  display7.writeDigitBCD(2,6);                  // Write Buffer Digit[2] : [?][?][2][?]
  //
  display0.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display1.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display2.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display3.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display4.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display5.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display6.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  display7.writeDigitBCD(3,7);                  // Write Buffer Digit[3] : [?][?][?][3]
  //=======================================================================================
  display0.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display1.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display2.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display3.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display4.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display5.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display6.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  display7.writeDisplayPanel1();                // Transfer Buffer to Display Panel[1] & Update to HT16K33(Lower-MSB)
  //=======================================================================================

  //=======================================================================================
  // 4 Digit : [ ] [9] [A] [B]  
  // 4 Digit : [8] [9] [A] [B]  
  //=======================================================================================
  display0.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display1.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display2.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display3.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display4.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display5.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display6.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  display7.writeDigitBCD(0,8);                  // Write Buffer Digit[0] : [0][?][?][?]
  //
  display0.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display1.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display2.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display3.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display4.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display5.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display6.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  display7.writeDigitBCD(1,9);                  // Write Buffer Digit[1] : [?][1][?][?]
  //
  display0.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display1.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display2.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display3.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display4.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display5.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display6.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  display7.writeDigitBCD(2,0x0A);               // Write Buffer Digit[2] : [?][?][2][?]
  //
  display0.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display1.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display2.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display3.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display4.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display5.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display6.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  display7.writeDigitBCD(3,0x0B);               // Write Buffer Digit[3] : [?][?][?][3]
  //=======================================================================================
  display0.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display1.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display2.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display3.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display4.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display5.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display6.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  display7.writeDisplayPanel2();                // Transfer Buffer to Display Panel[2] & Update to HT16K33(Upper-LSB)
  //=======================================================================================

  //=======================================================================================
  // 3 Digit : [ ] [D] [E] [F]  
  // 4 Digit : [C] [D] [E] [F]  
  //=======================================================================================
  display0.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display1.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display2.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display3.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display4.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display5.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display6.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  display7.writeDigitBCD(0,0x0C);               // Write Buffer Digit[0] : [0][?][?][?]
  //
  display0.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display1.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display2.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display3.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display4.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display5.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display6.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  display7.writeDigitBCD(1,0x0D);               // Write Buffer Digit[1] : [?][1][?][?]
  //
  display0.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display1.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display2.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display3.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display4.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display5.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display6.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  display7.writeDigitBCD(2,0x0E);               // Write Buffer Digit[2] : [?][?][2][?]
  //
  display0.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display1.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display2.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display3.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display4.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display5.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display6.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  display7.writeDigitBCD(3,0x0F);               // Write Buffer Digit[3] : [?][?][?][3]
  //=======================================================================================
  display0.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display1.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display2.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display3.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display4.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display5.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display6.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  display7.writeDisplayPanel3();                // Transfer Buffer to Display Panel[3] & Update to HT16K33(Upper-MSB)
  //=======================================================================================
  delay(5000);
  //=======================================================================================
}


