/*******************************
 * Cypress : SPI FRAM(FM25L16B)
 */
 
#ifndef _ET_SPI_FRAM_H_
#define _ET_SPI_FRAM_H_

#if ARDUINO >= 100
 #include <Arduino.h>
#else
 #include <WProgram.h>
#endif

#include <SPI.h>

typedef enum opcodes_e
{
  OPCODE_WREN   = 0b0110,     /* Write Enable Latch */
  OPCODE_WRDI   = 0b0100,     /* Reset Write Enable Latch */
  OPCODE_RDSR   = 0b0101,     /* Read Status Register */
  OPCODE_WRSR   = 0b0001,     /* Write Status Register */
  OPCODE_READ   = 0b0011,     /* Read Memory */
  OPCODE_WRITE  = 0b0010,     /* Write Memory */
} opcodes_t;

class ET_SPI_FRAM 
{
 public:
  ET_SPI_FRAM(int8_t cs);
  ET_SPI_FRAM(int8_t clk, int8_t miso, int8_t mosi, int8_t cs);

  boolean  begin(void);
  void     writeEnable(bool enable);
  void     write8(uint16_t addr, uint8_t value);
  void     write(uint16_t addr, const uint8_t *values, size_t count);
  uint8_t  read8(uint16_t addr);
  uint8_t  getStatusRegister(void);
  void     setStatusRegister(uint8_t value);

 private:
  uint8_t  SPItransfer(uint8_t x);
  boolean _framInitialised;
  int8_t _cs, _clk, _mosi, _miso;
};

#endif
