/*
 * Demo ET-BIG7x2-I2C Master Hardware Board
 * MCU    : ATMEGA32U4(PRO-MICRO)
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : RTC:DS3231
 *        : PCF8575
 * ADC    : Analog#0 : A;[0..3]
 * Input  : RS485 ID0:D5
 *        : RS485 ID1:D6
 *        : RS485 ID2:D7
 *        : RS485 ID3:D8
 *        : RS485 ID4:D9
 * 1-Wire : DS18B20(1-Wire:D10)
 * 
 * Demo   : Display RS485-ID[00..31] on 7-Segment
 */

#include <Wire.h>                                                   // I2C Bus
#include "pcf8575.h"                                                // PCF8575
//===================================================================
#define I2C_SDA_PIN         2                                       // D2
#define I2C_SCL_PIN         3                                       // D3
//===================================================================
//===================================================================
#define SerialDebug         Serial                                  // USB Serial
#define SerialRS485         Serial1                                 // Serial1(D1=TXD,D0=RXD)
//===================================================================
//===================================================================
#define RS485_DIRECTION_PIN 4                                       // RS485 TXD Enable,Disable
#define RS485_RXD_SELECT    LOW
#define RS485_TXD_SELECT    HIGH
//===================================================================
//===================================================================
#define RS485_ID0_PIN       5                                       // Slave ID LSB
#define RS485_ID1_PIN       6         
#define RS485_ID2_PIN       7        
#define RS485_ID3_PIN       8        
#define RS485_ID4_PIN       9                                       // Slave ID MSB
//===================================================================
int NewAddressID = 0;
int OldAddressID = 0;
//===================================================================

//===================================================================
PCF8575 PCF8575_SLAVE0(0x20);                                       // PCF8575  = 0100,000+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE1(0x21);                                       // PCF8575  = 0100,001+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE2(0x22);                                       // PCF8575  = 0100,010+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE3(0x23);                                       // PCF8575  = 0100,011+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE4(0x24);                                       // PCF8575  = 0100,100+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE5(0x25);                                       // PCF8575  = 0100,101+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE6(0x26);                                       // PCF8575  = 0100,110+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE7(0x27);                                       // PCF8575  = 0100,111+(0:W,1:R)
//===================================================================

//===================================================================
// Initial Slave Address
//===================================================================
int GetMyAddressID()
{
  //=================================================================
  int SlaveAddress = 0;
  //=================================================================
  if(digitalRead(RS485_ID0_PIN) == HIGH)
  {
    SlaveAddress += 1;
  }
  if(digitalRead(RS485_ID1_PIN) == HIGH)
  {
    SlaveAddress += 2;
  }
  if(digitalRead(RS485_ID2_PIN) == HIGH)
  {
    SlaveAddress += 4;
  }
  if(digitalRead(RS485_ID3_PIN) == HIGH)
  {
    SlaveAddress += 8;
  }
  if(digitalRead(RS485_ID4_PIN) == HIGH)
  {
    SlaveAddress += 16;
  }
  //=================================================================
  return SlaveAddress;
  //=================================================================
}
//===================================================================

//===================================================================
void setup() 
{
  //=================================================================
  Wire.begin();                                                     // Initial I2C Bus
  //=================================================================
  
  //=================================================================
  // Initial RS485
  //=================================================================
  SerialRS485.begin(115200);
  //=================================================================
  pinMode(RS485_DIRECTION_PIN, OUTPUT);
  digitalWrite(RS485_DIRECTION_PIN, RS485_RXD_SELECT);
  //=================================================================
  pinMode(RS485_ID0_PIN, INPUT_PULLUP);
  pinMode(RS485_ID1_PIN, INPUT_PULLUP);
  pinMode(RS485_ID2_PIN, INPUT_PULLUP);
  pinMode(RS485_ID3_PIN, INPUT_PULLUP);
  pinMode(RS485_ID4_PIN, INPUT_PULLUP);
  //=================================================================
  NewAddressID = GetMyAddressID();
  OldAddressID = NewAddressID;
  //=================================================================
  //=================================================================  
  PCF8575_SLAVE0.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
  PCF8575_SLAVE1.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
  PCF8575_SLAVE2.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
  PCF8575_SLAVE3.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
  PCF8575_SLAVE4.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
  PCF8575_SLAVE5.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
  PCF8575_SLAVE6.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
  PCF8575_SLAVE7.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
  //=================================================================
  
  //=================================================================
  // Start of RS485 Test
  //=================================================================
  SerialDebug.begin(115200);
  while(!SerialDebug);                                             // wait USB Serial Ready
  //=================================================================
  SerialDebug.println("Hello This is ET-BIX7x2 I2C RS485");
  SerialDebug.print("My Address ID = ");
  SerialDebug.print((NewAddressID/10)%10);
  SerialDebug.println(NewAddressID%10);
  //=================================================================
  // End of RS485 Test
  //=================================================================
  
}

void loop() 
{
  NewAddressID = GetMyAddressID();
  if(NewAddressID != OldAddressID)
  {
    //===============================================================  
    PCF8575_SLAVE0.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
    PCF8575_SLAVE1.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
    PCF8575_SLAVE2.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
    PCF8575_SLAVE3.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
    PCF8575_SLAVE4.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
    PCF8575_SLAVE5.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
    PCF8575_SLAVE6.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
    PCF8575_SLAVE7.write_bcd_normal(((NewAddressID/10)%10),(NewAddressID%10),false,false); 
    //===============================================================
    OldAddressID = NewAddressID;
    //===============================================================
    //===============================================================
    // Start of RS485 Test
    //===============================================================
    SerialDebug.println("Hello This is ET-BIX7x2 I2C RS485");
    SerialDebug.print("My Address ID = ");
    SerialDebug.print((NewAddressID/10)%10);
    SerialDebug.println(NewAddressID%10);
    //===============================================================
    // End of RS485 Test
    //===============================================================
  }
}

