/*
 * Demo ET-BIG7x2-I2C Master Hardware Board
 * MCU    : ATMEGA32U4(PRO-MICRO)
 *        : Arduino Leonado
 *        : Bootloader
 *        : -> .../caterina/Caterina-Leonardo.hex
 *        : Fuse Bit
 *        : -> low_fuses      = 0xFF
 *        : -> high_fuses     = 0xD8
 *        : -> extended_fuses = 0xCB(0xFB)
 *        : Lock Bit
 *        : -> 0x2F(0xEF)
 * RS485  : RS485 RXD:D0
 *        : RS485 TXD:D1
 *        : RS485 Direction(D4:LOW=Receive,HIGH=Send)
 * I2C    : SCL=D3,SDA=D2
 *        : RTC:DS3231
 *        : PCF8575
 * ADC    : Analog#0 : A;[0..3]
 * Input  : RS485 ID0:D5
 *        : RS485 ID1:D6
 *        : RS485 ID2:D7
 *        : RS485 ID3:D8
 *        : RS485 ID4:D9
 * 1-Wire : DS18B20(1-Wire:D10)
 * 
 * Demo   : Test 7-Segment Display Slave Board
 */

#include <Wire.h>                                                   // I2C Bus
#include "pcf8575.h"                                                // PCF8575
//
//===================================================================
#define I2C_SDA_PIN         2                                       // D2
#define I2C_SCL_PIN         3                                       // D3
//===================================================================

//===================================================================
PCF8575 PCF8575_SLAVE0(0x20);                                       // PCF8575  = 0100,000+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE1(0x21);                                       // PCF8575  = 0100,001+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE2(0x22);                                       // PCF8575  = 0100,010+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE3(0x23);                                       // PCF8575  = 0100,011+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE4(0x24);                                       // PCF8575  = 0100,100+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE5(0x25);                                       // PCF8575  = 0100,101+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE6(0x26);                                       // PCF8575  = 0100,110+(0:W,1:R)
//===================================================================
PCF8575 PCF8575_SLAVE7(0x27);                                       // PCF8575  = 0100,111+(0:W,1:R)
//===================================================================

void setup() 
{
  //=================================================================
  Wire.begin(false);                                                // Initial I2C Bus
  //=================================================================
  
  //=================================================================
  PCF8575_SLAVE0.write_seg(0x00,0x00);                              // Clear Display(Blank) 
  PCF8575_SLAVE1.write_seg(0x00,0x00);                              // Clear Display(Blank) 
  PCF8575_SLAVE2.write_seg(0x00,0x00);                              // Clear Display(Blank) 
  PCF8575_SLAVE3.write_seg(0x00,0x00);                              // Clear Display(Blank) 
  PCF8575_SLAVE4.write_seg(0x00,0x00);                              // Clear Display(Blank) 
  PCF8575_SLAVE5.write_seg(0x00,0x00);                              // Clear Display(Blank) 
  PCF8575_SLAVE6.write_seg(0x00,0x00);                              // Clear Display(Blank) 
  PCF8575_SLAVE7.write_seg(0x00,0x00);                              // Clear Display(Blank) 
  //=================================================================
}

void loop() 
{
  //=================================================================
  // Test Display Segment : A..G,Dp
  //=================================================================
  for(uint8_t seg=0; seg<8; seg++)                                  // Seg-A,Seg-B,Seg-C,...,Seg-G,Seg-Dp
  {
    //===============================================================
    PCF8575_SLAVE0.write_seg((1<<(seg)),(1<<(seg)));  
    PCF8575_SLAVE1.write_seg((1<<(seg)),(1<<(seg)));  
    PCF8575_SLAVE2.write_seg((1<<(seg)),(1<<(seg)));  
    PCF8575_SLAVE3.write_seg((1<<(seg)),(1<<(seg)));  
    PCF8575_SLAVE4.write_seg((1<<(seg)),(1<<(seg)));  
    PCF8575_SLAVE5.write_seg((1<<(seg)),(1<<(seg)));  
    PCF8575_SLAVE6.write_seg((1<<(seg)),(1<<(seg)));  
    PCF8575_SLAVE7.write_seg((1<<(seg)),(1<<(seg)));  
    //===============================================================
   
    //===============================================================
    delay(1000);
    //===============================================================
  }
  //=================================================================

  //=================================================================
  // Test Display Number : 0..9,A..F
  //=================================================================  
  for(uint16_t bcd=0; bcd<16; bcd++)                                // 0..9,A..F
  {
    //===============================================================
    PCF8575_SLAVE0.write_bcd_normal(bcd,bcd,false,false); 
    PCF8575_SLAVE1.write_bcd_normal(bcd,bcd,false,false); 
    PCF8575_SLAVE2.write_bcd_normal(bcd,bcd,false,false); 
    PCF8575_SLAVE3.write_bcd_normal(bcd,bcd,false,false); 
    PCF8575_SLAVE4.write_bcd_normal(bcd,bcd,false,false); 
    PCF8575_SLAVE5.write_bcd_normal(bcd,bcd,false,false); 
    PCF8575_SLAVE6.write_bcd_normal(bcd,bcd,false,false); 
    PCF8575_SLAVE7.write_bcd_normal(bcd,bcd,false,false); 
    //===============================================================
    
    //===============================================================
    delay(1000);
    //===============================================================
  }
  //=================================================================

  while(1)
  {
    //===============================================================
    // Test Display Device Slave ID : 00,01,02,03,04,05,06,07
    //===============================================================  
    PCF8575_SLAVE0.write_bcd_normal(0,0,false,false); 
    PCF8575_SLAVE1.write_bcd_normal(0,1,false,false); 
    PCF8575_SLAVE2.write_bcd_normal(0,2,false,false); 
    PCF8575_SLAVE3.write_bcd_normal(0,3,false,false); 
    PCF8575_SLAVE4.write_bcd_normal(0,4,false,false); 
    PCF8575_SLAVE5.write_bcd_normal(0,5,false,false); 
    PCF8575_SLAVE6.write_bcd_normal(0,0,false,false); 
    PCF8575_SLAVE7.write_bcd_normal(0,7,false,false); 
    //===============================================================
    //===============================================================
    delay(250);  
    //===============================================================
  }
  
}

