/************************************************/
/* Demo Program For ET-BASE PIC40/4550(ICSP)    */
/* MCU Control : PIC18F4550                     */
/*             : Run 48MHz(X-TAL 8.00MHz + PLL) */
/* Compiler    : C18 Version 3.41               */
/* Function    : LED Blinking on RA2            */
/************************************************/

/** C O N F I G U R A T I O N   B I T S ******************************/
//ETT:ET-BASE PIC40/4550(PIC18F4550) 
#pragma config PLLDIV   = 2         	// (8 MHz crystal on ET-BASE PIC18 board)
#pragma config CPUDIV   = OSC1_PLL2    	// [Primary Oscillator Src: /1][96 MHz PLL Src: /2] 
#pragma config USBDIV   = 2             // Clock source from 96MHz PLL/2
#pragma config FOSC     = HSPLL_HS		// Clock Source = HS+PLL
#pragma config FCMEN    = OFF			// Fail-Safe Clock Monitor disabled
#pragma config IESO     = OFF			// Oscillator Switchover mode disabled
#pragma config PWRT     = ON			// Power-up Timer Enable
#pragma config BOR      = ON			// Brown-out Reset enabled in hardware only (SBOREN is disabled) 
#pragma config BORV     = 0				// Brown-out Reset Voltage = Maximum setting
#pragma config VREGEN   = ON      		// USB Voltage Regulator
#pragma config WDT      = OFF			// WDT disabled (control is placed on the SWDTEN bit) 
#pragma config WDTPS    = 32768			// Watchdog Timer Postscale = 1:32768	
#pragma config CCP2MX   = OFF  			// CCP2 input/output is multiplexed with RB3 
#pragma config PBADEN   = OFF			// PORTB<4:0> pins are configured as digital I/O on Reset
#pragma config LPT1OSC  = OFF			// Timer1 configured for higher power operation 
#pragma config MCLRE    = ON			// MCLR pin enabled; RE3 input pin disabled
#pragma config STVREN   = ON			// Stack full/underflow will cause Reset
#pragma config LVP      = OFF			// Single-Supply ICSP disabled
#pragma config ICPRT    = ON            // ***Enable In-Circuit Debug/Programming***
#pragma config XINST    = OFF       	// Extended Instruction Set
#pragma config DEBUG    = ON            // Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug 

//Disable All Protect
#pragma config CP0      = OFF			// Block 0 (000800-001FFFh) is not code-protected
#pragma config CP1      = OFF			// Block 1 (002000-003FFFh) is not code-protected
#pragma config CP2      = OFF			// Block 2 (004000-005FFFh) is not code-protected
#pragma config CP3      = OFF			// Block 3 (006000-007FFFh) is not code-protected
#pragma config CPB      = OFF			// Boot block (000000-0007FFh) is not code-protected
#pragma config CPD      = OFF			// Data EEPROM is not code-protected 
#pragma config WRT0     = OFF			// Block 0 (000800-001FFFh) is not write-protected
#pragma config WRT1     = OFF			// Block 1 (002000-003FFFh) is not write-protected
#pragma config WRT2     = OFF			// Block 2 (004000-005FFFh) is not write-protected
#pragma config WRT3     = OFF			// Block 3 (006000-007FFFh) is not write-protected
#pragma config WRTC     = OFF			// Configuration registers (300000-3000FFh) are not write-protected
#pragma config WRTB     = OFF       	// Boot block (000000-0007FFh) is not write-protected 
#pragma config WRTD     = OFF			// Data EEPROM is not write-protected
#pragma config EBTR0    = OFF			// Block 0 (000800-001FFFh) is not protected from table reads executed in other blocks
#pragma config EBTR1    = OFF			// Block 1 (002000-003FFFh) is not protected from table reads executed in other blocks
#pragma config EBTR2    = OFF			// Block 2 (004000-005FFFh) is not protected from table reads executed in other blocks 
#pragma config EBTR3    = OFF			// Block 3 (006000-007FFFh) is not protected from table reads executed in other blocks
#pragma config EBTRB    = OFF			// Boot block (000000-0007FFh) is not protected from table reads executed in other blocks
//ETT:ET-BASE PIC40/4550(PIC18F4550)

/** I N C L U D E S **************************************************/
#include "p18f4550.h"
#include "delays.h"

/** POT(RA0)*******************************************************/
#define InitPOT()          {TRISAbits.TRISA0=1;ADCON1bits.PCFG = 14;}

/** SWITCH(RA1)****************************************************/
#define InitSwitch1()      {TRISAbits.TRISA1=1;}
#define sw1                PORTAbits.RA1
 
/** LED(RA2)*******************************************************/
#define InitLED1()         {LATAbits.LATA2=0; TRISAbits.TRISA2=0;}	
#define LED1               LATAbits.LATA2    
#define LED1_On()          LED1 = 1;    
#define LED1_Off()         LED1 = 0;
#define LED1_Toggle()      LED1 = !LED1;

/** Run 48.00 MHz **************************************************/
#define CLOCK_FREQ 		   48000000   
#define GetSystemClock()   48000000

/** D E C L A R A T I O N S *******************************************/
void main (void)
{
  ADCON1bits.PCFG = 14;				// RA0 = ADC Only
  InitLED1();						// Initial LED = Output
  while (1)
  {
    LED1_Toggle();					// Toggle LED
    Delay10KTCYx(250);				// Delay multiples of 10,000 Tcy
  }	
}
