/************************************************/
/* Demo Program For ET-BASE PIC40/46K80(ICSP)   */
/* MCU Control : PIC18F46K80                    */
/*             : Run 64MHz(Internal 16MHz+PLL)  */
/* Compiler    : PIC-CCS Version 4.120          */
/* Function    : Demo UART1,UART2 Echo Test     */
/************************************************/
#include <18F46K80.h>
#include <stdlib.h>

// Fuses: PIC18F46K80(CCS Compiler)
//////// Fuses: VREGSLEEP_SW,VREGSLEEP,INTRC_LP,INTRC_HP,SOSC_LOW,SOSC_DIG
//////// Fuses: SOSC_HIGH,NOXINST,XINST,LP,XT,HSH,HSM,ECH,ECH_IO,RC,RC_IO
//////// Fuses: INTRC_IO,INTRC,ECM,ECM_IO,ECL,ECL_IO,NOPLLEN,PLLEN,NOFCMEN
//////// Fuses: FCMEN,NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW
//////// Fuses: BROWNOUT_NOSL,BROWNOUT,BORV30,BORV27,BORV20,BORV18,BORM_LOW
//////// Fuses: BORM_MED,BORM_HIGH,ZPBORM,NOWDT,WDT_NOSLEEP,WDT_SW,WDT,WDT1
//////// Fuses: WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128,WDT256,WDT512
//////// Fuses: WDT1024,WDT2048,WDT4096,WDT8192,WDT16384,WDT32768,WDT65536
//////// Fuses: WDT131072,WDT262144,WDT524288,WDT1048576,CANC,CANB,MSSPMSK5
//////// Fuses: MSSPMSK7,NOMCLR,MCLR,NOSTVREN,STVREN,BBSIZ1K,BBSIZ2K,DEBUG
//////// Fuses: NODEBUG,PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC
//////// Fuses: NOWRTC,WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses INTRC_IO,PLLEN,NOWDT,NOPROTECT,NODEBUG,SOSC_DIG                        // Ineternal 16MHz + PLL(4) = 64MHz 
#use delay(clock=64000000)

/* Config and Enable Hardware UART1(RC6=TX1,RC7=RX1 */
#use rs232(uart1, baud=9600, stream=CH1)

/* Config and Enable Software UART(RC0=TX2,RC1=RX2 */
#define TX2 PIN_C0                                                            
#define RX2 PIN_C1                                                            
#use rs232(baud=9600, xmit=TX2, rcv=RX2,stream=CH2)

/* Config and Enable Hardware UART2(RD6=TX3,RD7=RX3 */
//#use rs232(uart2, baud=9600, stream=CH3)

/****************/
/* Main Program */
/****************/
void main() 
{  
  char rx_buff;
  
  setup_oscillator(OSC_16MHZ|OSC_PLL_ON);                                     // Sets the Internal Oscillator to 64MHz (PLL Enabled)  
  delay_ms(500);                                                              // Power-On Delay
  
  //Start-Up UART1
  fprintf(CH1,"\n\n\n\r");
  fprintf(CH1,"Demo UART1 ET-BASE PIC40/46K80(ICD2)\n\r");
  fprintf(CH1,"Run 64.00 MHz(Internal 16 MHz + PLL)\n\r");  
  fprintf(CH1,"UART1>");
  
  //Start-Up UART2
  fprintf(CH2,"\n\n\n\r");
  fprintf(CH2,"Demo UART2 ET-BASE PIC40/46K80(ICD2)\n\r");
  fprintf(CH2,"Run 64.00 MHz(Internal 16 MHz + PLL)\n\r");  
  fprintf(CH2,"UART2>");
  
  //Start-Up UART2
  //fprintf(CH3,"\n\n\n\r");
  //fprintf(CH3,"Demo UART3 ET-BASE PIC40/46K80(ICD2)\n\r");
  //fprintf(CH3,"Run 64.00 MHz(Internal 16 MHz + PLL)\n\r");  
  //fprintf(CH3,"UART3>");
  
  while(true)
  { 
    //Verify & Echo UART1
    if(kbhit(CH1))
    {
      rx_buff = fgetc(CH1);
      if (rx_buff == 0x0D)
      {
        fprintf(CH1,"\n\r");
        fprintf(CH1,"ET-BASE PIC40/46K80(ICD2)\n\r");
        fprintf(CH1,"UART1>");
      }
      else 
      {
        fputc(rx_buff,CH1);                                                   // Echo Received Characters      
      }
    }  
    
    //Verify & Echo UART2
    if(kbhit(CH2))
    {
      rx_buff = fgetc(CH2);
      if (rx_buff == 0x0D)
      {
        fprintf(CH2,"\n\r");
        fprintf(CH2,"ET-BASE PIC40/46K80(ICD2)\n\r");
        fprintf(CH2,"UART2>");
      }
      else 
      {
        fputc(rx_buff,CH2);                                                   // Echo Received Characters      
      }
    }  
    
    //Verify & Echo UART3
    //if(kbhit(CH3))
    //{
    //  rx_buff = fgetc(CH3);
    //  if (rx_buff == 0x0D)
    //  {
    //    fprintf(CH3,"\n\r");
    //    fprintf(CH3,"ET-BASE PIC40/46K80(ICD2)\n\r");
    //    fprintf(CH3,"UART3>");
    //  }
    //  else 
    //  {
    //    fputc(rx_buff,CH3);                                                   // Echo Received Characters      
    //  }
    //}  
  }  
}

