/***********************************************/
/* Demo Program For ET-BASE PIC40/46K80(ICSP)  */
/* MCU Control : PIC18F46K80                   */
/*             : Run 64MHz(Internal 16MHz+PLL) */ 
/* Compiler    : PIC-CCS Version 4.120         */
/* Function    : Demo Switch Control LED ON/OFF*/
/***********************************************/

#include <18F46K80.h>
#include <stdlib.h>

// Fuses: PIC18F46K80(CCS Compiler)
//////// Fuses: VREGSLEEP_SW,VREGSLEEP,INTRC_LP,INTRC_HP,SOSC_LOW,SOSC_DIG
//////// Fuses: SOSC_HIGH,NOXINST,XINST,LP,XT,HSH,HSM,ECH,ECH_IO,RC,RC_IO
//////// Fuses: INTRC_IO,INTRC,ECM,ECM_IO,ECL,ECL_IO,NOPLLEN,PLLEN,NOFCMEN
//////// Fuses: FCMEN,NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW
//////// Fuses: BROWNOUT_NOSL,BROWNOUT,BORV30,BORV27,BORV20,BORV18,BORM_LOW
//////// Fuses: BORM_MED,BORM_HIGH,ZPBORM,NOWDT,WDT_NOSLEEP,WDT_SW,WDT,WDT1
//////// Fuses: WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128,WDT256,WDT512
//////// Fuses: WDT1024,WDT2048,WDT4096,WDT8192,WDT16384,WDT32768,WDT65536
//////// Fuses: WDT131072,WDT262144,WDT524288,WDT1048576,CANC,CANB,MSSPMSK5
//////// Fuses: MSSPMSK7,NOMCLR,MCLR,NOSTVREN,STVREN,BBSIZ1K,BBSIZ2K,DEBUG
//////// Fuses: NODEBUG,PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC
//////// Fuses: NOWRTC,WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses INTRC_IO,PLLEN,NOWDT,NOPROTECT,NODEBUG,SOSC_DIG                        // Ineternal 16MHz + PLL(4) = 64MHz 
#use delay(clock=64000000)

//SW1
#define SW1         PIN_A1                                                    // Switch SW1  

//LED Status(Actin High)
#define LED         PIN_A2                                                    // LED Selftest

/****************/
/* Main Program */
/****************/
void main() 
{    
  setup_oscillator(OSC_16MHZ|OSC_PLL_ON);                                     // Sets the Internal Oscillator to 64MHz (PLL Enabled)
  SETUP_ADC_PORTS(NO_ANALOGS); 
  output_drive(LED);                                                          // LED Drive Pin = Output
  output_float(SW1);                                                          // SW1 Read Pin = Input
  output_High(LED);                                                           // Default LED = ON  
  
  while(true)
  {   
    while(input(PIN_A1));                                                     // Wait SW1 Press(Low)
    delay_ms(10);
    
    output_toggle(LED);                                                       // Toggle LED
    
    while(!input(PIN_A1));                                                    // Wait SW1 Release(High)
    delay_ms(10);                                                                   
  }  
}


