/************************************************/
/* Demo Program For ET-BASE PIC40/46K80(ICSP)   */
/* MCU Control : PIC18F46K80                    */
/*             : Run 64MHz(Internal 16MHz+PLL)  */
/* Compiler    : PIC-CCS Version 4.120          */
/* Function    : Demo All GPIO Output Demo Test */
/************************************************/
// Used Internal RC 8MHz + PLL(4) Clock
// Select Jumper RA[7..6]/XTAL  = RA[7..6]
// Select Jumper RC[5..3]/USB   = RC[5..3]
// Select Jumper RC[1..0]/UART2 = RC[1..0]

#include <18F46K80.h>
#include <stdlib.h>

// Fuses: PIC18F46K80(CCS Compiler)
//////// Fuses: VREGSLEEP_SW,VREGSLEEP,INTRC_LP,INTRC_HP,SOSC_LOW,SOSC_DIG
//////// Fuses: SOSC_HIGH,NOXINST,XINST,LP,XT,HSH,HSM,ECH,ECH_IO,RC,RC_IO
//////// Fuses: INTRC_IO,INTRC,ECM,ECM_IO,ECL,ECL_IO,NOPLLEN,PLLEN,NOFCMEN
//////// Fuses: FCMEN,NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW
//////// Fuses: BROWNOUT_NOSL,BROWNOUT,BORV30,BORV27,BORV20,BORV18,BORM_LOW
//////// Fuses: BORM_MED,BORM_HIGH,ZPBORM,NOWDT,WDT_NOSLEEP,WDT_SW,WDT,WDT1
//////// Fuses: WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128,WDT256,WDT512
//////// Fuses: WDT1024,WDT2048,WDT4096,WDT8192,WDT16384,WDT32768,WDT65536
//////// Fuses: WDT131072,WDT262144,WDT524288,WDT1048576,CANC,CANB,MSSPMSK5
//////// Fuses: MSSPMSK7,NOMCLR,MCLR,NOSTVREN,STVREN,BBSIZ1K,BBSIZ2K,DEBUG
//////// Fuses: NODEBUG,PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC
//////// Fuses: NOWRTC,WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses INTRC_IO,PLLEN,NOWDT,NOPROTECT,NODEBUG,SOSC_DIG                        // Ineternal 16MHz + PLL(4) = 64MHz 
#use delay(clock=64000000)

const unsigned char LED[8] =
{
  0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80                              // 8 Bit LED Test
};
 
/****************/
/* Main Program */
/****************/
void main() 
{
  unsigned char count;
  
  setup_oscillator(OSC_16MHZ|OSC_PLL_ON);                                     // Sets the Internal Oscillator to 64MHz (PLL Enabled)
  set_tris_a(0b11000011);                                                     // RA[5..2]=Output,RA[7..6,1..0]=Input
  set_tris_b(0b00000000);                                                     // RB[7..0]=Output
  set_tris_c(0b00000000);                                                     // RC[7..0]=Output
  set_tris_d(0b00000000);                                                     // RD[7..0]=Output
  set_tris_e(0b11111000);                                                     // RE[2..0]=Output
                        
  while(true)
  {    
    for(count = 0; count < 8; count++)                                        // 8 Bit LED 
    {    
      output_a(~LED[count]);    
      output_b(~LED[count]);
      output_c(~LED[count]);
      output_d(~LED[count]);
      output_e(~LED[count]);
      delay_ms(500);                             
    }  
  }
}  

