/***********************************************/
/* Demo Program For ET-BASE PIC40/46K80(ICSP)  */
/* MCU Control : PIC18F46K80                   */
/*             : Run 64MHz(Internal 16MHz+PLL) */ 
/* Compiler    : PIC-CCS Version 4.120         */
/* Function    : Demo ADC Display UART1(RS232) */
/*             : Display Bargraph LED(Port-D)  */
/***********************************************/
#include <18F46K80.h>
#DEVICE  ADC = 12                                                             //12Bit ADC + Signed
#include <stdlib.h>

// Fuses: PIC18F46K80(CCS Compiler)
//////// Fuses: VREGSLEEP_SW,VREGSLEEP,INTRC_LP,INTRC_HP,SOSC_LOW,SOSC_DIG
//////// Fuses: SOSC_HIGH,NOXINST,XINST,LP,XT,HSH,HSM,ECH,ECH_IO,RC,RC_IO
//////// Fuses: INTRC_IO,INTRC,ECM,ECM_IO,ECL,ECL_IO,NOPLLEN,PLLEN,NOFCMEN
//////// Fuses: FCMEN,NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW
//////// Fuses: BROWNOUT_NOSL,BROWNOUT,BORV30,BORV27,BORV20,BORV18,BORM_LOW
//////// Fuses: BORM_MED,BORM_HIGH,ZPBORM,NOWDT,WDT_NOSLEEP,WDT_SW,WDT,WDT1
//////// Fuses: WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128,WDT256,WDT512
//////// Fuses: WDT1024,WDT2048,WDT4096,WDT8192,WDT16384,WDT32768,WDT65536
//////// Fuses: WDT131072,WDT262144,WDT524288,WDT1048576,CANC,CANB,MSSPMSK5
//////// Fuses: MSSPMSK7,NOMCLR,MCLR,NOSTVREN,STVREN,BBSIZ1K,BBSIZ2K,DEBUG
//////// Fuses: NODEBUG,PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC
//////// Fuses: NOWRTC,WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses INTRC_IO,PLLEN,NOWDT,NOPROTECT,NODEBUG,SOSC_DIG                        // Ineternal 16MHz + PLL(4) = 64MHz 
#use delay(clock=64000000)

/* Config and Enable Hardware UART1(RC6=TX1,RC7=RX1 */
#use rs232(uart1, baud=9600)

//ADC0:RA0:VR1 -> Demo Test ADC
#define ADC0_PIN    PIN_A0                                                    // ADC0(VR1)

//Bargraph LED Display ADC Scale Result
const unsigned char LED[8] =
{
  0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF                              // 8 Bit LED Test
};

/****************/
/* Main Program */
/****************/
void main() 
{ 
  signed int16 AN0_Value;
  
  setup_oscillator(OSC_16MHZ|OSC_PLL_ON);                                     // Sets the Internal Oscillator to 64MHz (PLL Enabled)  
  output_float(ADC0_PIN);                                                     // ADC Input
  setup_adc(ADC_CLOCK_DIV_64|ADC_TAD_MUL_20);
  setup_adc_ports(sAN0|VSS_VDD);                                              // ADC Range VSS to +VDD
  set_adc_channel(0);                                                         // Select Channel AN0
  set_tris_d(0b00000000);                                                     // RD[7..0] = Output LED Bargraph
  
  delay_ms(500);
  printf("\n\n\n\r");
  printf("Demo ADC ET-BASE PIC40/46K80(ICSP)\n\r");
  printf("Run 64MHz(Internal 16MHz + PLL[4])\n\n\r");  
  
  while(true)
  { 
    read_adc(ADC_START_ONLY);
    int1 done = adc_done();
    while(!done) 
    {
      done = adc_done();
    }
    AN0_value = read_adc();
    
    if(AN0_value < 0)
    {
      AN0_value = 0;
    }
    
    printf("ADC[0] : AN0 = %x \r",AN0_Value);
    output_d(~LED[AN0_Value/512]);                                            // Display ADC Scale to Bargraph LED
    delay_ms(50);
  }  
}

