/************************************************/
/* Demo Program For ET-BASE PIC40/46K22(ICSP)   */
/* MCU Control : PIC18F46K22                    */
/*             : Run 64MHz(Internal 16MHz+PLL)  */
/* Function    : Demo UART1,UART2 Echo Test     */
/************************************************/
#include <18F46K22.h>
#include <stdlib.h>

// Fuses: PIC18F46K22(CCS Compiler)
//////// Fuses: LP,XT,HSH,HSM,ECH,ECH_IO,RC,RC_IO,INTRC_IO,INTRC,ECM,ECM_IO
//////// Fuses: ECL,ECL_IO,NOPLLEN,PLLEN,PRIMARY_SW,PRIMARY_ON,NOFCMEN,FCMEN
//////// Fuses: NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW,BROWNOUT_NOSL
//////// Fuses: BROWNOUT,BORV45,BORV42,BORV27,BORV20,NOWDT,WDT_NOSLEEP
//////// Fuses: WDT_SW,WDT,WDT1,WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128
//////// Fuses: WDT256,WDT512,WDT1024,WDT2048,WDT4096,WDT8192,WDT16384
//////// Fuses: WDT32768,CCP2B3,CCP2C1,NOPBADEN,PBADEN,CCP3E0,CCP3B5
//////// Fuses: NOHFOFST,HFOFST,TIMER3B5,TIMER3C0,CCP2C0,CCP2D2,NOMCLR,MCLR
//////// Fuses: NOSTVREN,STVREN,NOLVP,LVP,NOXINST,XINST,DEBUG,NODEBUG
//////// Fuses: PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC,NOWRTC
//////// Fuses: WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses INTRC_IO,NOWDT,NOPROTECT,NODEBUG,PLLEN                                 // Ineternal 16MHz + PLL(4) = 64MHz 
#use delay(clock=64000000)

/* Config and Enable Hardware UART1(RC6=TX1,RC7=RX1 */
#use rs232(uart1, baud=9600, stream=CH1)

/* Config and Enable Software UART2(RC0=TX2,RC1=RX2 */
#define TX2 PIN_C0                                                            // RC0 = TXD
#define RX2 PIN_C1                                                            // RC1 = RXD
#use rs232(baud=9600, xmit=TX2, rcv=RX2,stream=CH2)

/****************/
/* Main Program */
/****************/
void main() 
{  
  char rx_buff;
  
  setup_oscillator(OSC_16MHZ|OSC_PLL_ON);                                     // Sets the Internal Oscillator to 64MHz (PLL Enabled)
  delay_ms(500);                                                              // Power-On Delay
  
  //Start-Up UART1
  fprintf(CH1,"\n\n\n\r");
  fprintf(CH1,"Demo UART1 ET-BASE PIC40/46K22(ICD2)\n\r");
  fprintf(CH1,"Run 64.00 MHz(Internal 16 MHz + PLL)\n\r");  
  fprintf(CH1,"UART1>");
  
  //Start-Up UART2
  fprintf(CH2,"\n\n\n\r");
  fprintf(CH2,"Demo UART2 ET-BASE PIC40/46K22(ICD2)\n\r");
  fprintf(CH2,"Run 64.00 MHz(Internal 16 MHz + PLL)\n\r");  
  fprintf(CH2,"UART2>");
  
  while(true)
  { 
    //Verify & Echo UART1
    if(kbhit(CH1))
    {
      rx_buff = fgetc(CH1);
      if (rx_buff == 0x0D)
      {
        fprintf(CH1,"\n\r");
        fprintf(CH1,"ET-BASE PIC40/46K22(ICD2)\n\r");
        fprintf(CH1,"UART1>");
      }
      else 
      {
        fputc(rx_buff,CH1);                                                   // Echo Received Characters      
      }
    }  
    
    //Verify & Echo UART2
    if(kbhit(CH2))
    {
      rx_buff = fgetc(CH2);
      if (rx_buff == 0x0D)
      {
        fprintf(CH2,"\n\r");
        fprintf(CH2,"ET-BASE PIC40/46K22(ICD2)\n\r");
        fprintf(CH2,"UART2>");
      }
      else 
      {
        fputc(rx_buff,CH2);                                                   // Echo Received Characters      
      }
    }  
  }  
}

