/***********************************************/
/* Demo Program For ET-BASE PIC40/46K22(ICSP)  */
/* MCU Control : PIC18F46K22                   */
/*             : Run 64MHz(Internal 16MHz+PLL) */ 
/* Compiler    : PIC-CCS Version 4.120         */
/* Function    : Demo Output LED(RA2) Blinking */
/***********************************************/

#include <18F46K22.h>
#include <stdlib.h>

// Fuses: PIC18F46K22(CCS Compiler)
//////// Fuses: LP,XT,HSH,HSM,ECH,ECH_IO,RC,RC_IO,INTRC_IO,INTRC,ECM,ECM_IO
//////// Fuses: ECL,ECL_IO,NOPLLEN,PLLEN,PRIMARY_SW,PRIMARY_ON,NOFCMEN,FCMEN
//////// Fuses: NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW,BROWNOUT_NOSL
//////// Fuses: BROWNOUT,BORV45,BORV42,BORV27,BORV20,NOWDT,WDT_NOSLEEP
//////// Fuses: WDT_SW,WDT,WDT1,WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128
//////// Fuses: WDT256,WDT512,WDT1024,WDT2048,WDT4096,WDT8192,WDT16384
//////// Fuses: WDT32768,CCP2B3,CCP2C1,NOPBADEN,PBADEN,CCP3E0,CCP3B5
//////// Fuses: NOHFOFST,HFOFST,TIMER3B5,TIMER3C0,CCP2C0,CCP2D2,NOMCLR,MCLR
//////// Fuses: NOSTVREN,STVREN,NOLVP,LVP,NOXINST,XINST,DEBUG,NODEBUG
//////// Fuses: PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC,NOWRTC
//////// Fuses: WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses INTRC_IO,NOWDT,NOPROTECT,NODEBUG,PLLEN                                 // Ineternal 16MHz + PLL(4) = 64MHz 
#use delay(clock=64000000)

//LED Status(Actin High)
#define LED         PIN_A2                                                    // LED Selftest

/****************/
/* Main Program */
/****************/
void main() 
{
  setup_oscillator(OSC_16MHZ|OSC_PLL_ON);                                     // Sets the Internal Oscillator to 64MHz (PLL Enabled)
  output_drive(LED);                                                          // LED Drive Pin = Output
                        
  while(true)
  {     
    output_toggle(LED);                                                       // Toggle ON/OFF LED
    delay_ms(500);
    
    //output_low(LED);                                                        // OFF LED
    //delay_ms(500);    
    //output_high(LED);                                                       // ON LED
    //delay_ms(500);
    
    //output_bit(LED,0);                                                      // OFF LED
    //delay_ms(500);
    //output_bit(LED,1);                                                      // ON LED
    //delay_ms(500);                                       
  }  
}


