/***********************************************/
/* Demo Program For ET-BASE PIC40/46K22(ICSP)  */
/* MCU Control : PIC18F46K22                   */
/*             : Run 64MHz(Internal 16MHz+PLL) */ 
/* Compiler    : PIC-CCS Version 4.120         */
/* Function    : Demo ADC Display UART1(RS232) */
/***********************************************/
#include <18F46K22.h>
#include <stdlib.h>

// Fuses: PIC18F46K22(CCS Compiler)
//////// Fuses: LP,XT,HSH,HSM,ECH,ECH_IO,RC,RC_IO,INTRC_IO,INTRC,ECM,ECM_IO
//////// Fuses: ECL,ECL_IO,NOPLLEN,PLLEN,PRIMARY_SW,PRIMARY_ON,NOFCMEN,FCMEN
//////// Fuses: NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW,BROWNOUT_NOSL
//////// Fuses: BROWNOUT,BORV45,BORV42,BORV27,BORV20,NOWDT,WDT_NOSLEEP
//////// Fuses: WDT_SW,WDT,WDT1,WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128
//////// Fuses: WDT256,WDT512,WDT1024,WDT2048,WDT4096,WDT8192,WDT16384
//////// Fuses: WDT32768,CCP2B3,CCP2C1,NOPBADEN,PBADEN,CCP3E0,CCP3B5
//////// Fuses: NOHFOFST,HFOFST,TIMER3B5,TIMER3C0,CCP2C0,CCP2D2,NOMCLR,MCLR
//////// Fuses: NOSTVREN,STVREN,NOLVP,LVP,NOXINST,XINST,DEBUG,NODEBUG
//////// Fuses: PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC,NOWRTC
//////// Fuses: WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses INTRC_IO,NOWDT,NOPROTECT,NODEBUG,PLLEN                                 // Ineternal 16MHz + PLL(4) = 64MHz 
#use delay(clock=64000000)

/* Config and Enable Hardware UART1(RC6=TX1,RC7=RX1 */
#use rs232(uart1, baud=9600)

//ADC0:RA0:VR1 -> Demo Test ADC
#define ADC0_PIN    PIN_A0                                                    // ADC0(VR1)

//LED Barfraph Display Scale ADC Result
const unsigned char LED[8] =
{
  0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF                              // 8 Bit LED Test
};

/****************/
/* Main Program */
/****************/
void main() 
{ 
  int8 AN0_Value;
  
  setup_oscillator(OSC_16MHZ|OSC_PLL_ON);                                     // Sets the Internal Oscillator to 64MHz (PLL Enabled)  
  output_float(ADC0_PIN);                                                     // ADC Input
  setup_adc_ports(sAN0);                                                      // Assign Analog pin
  setup_adc(ADC_CLOCK_INTERNAL);                                      
  
  //Used RD[7..0]= Bargraph Display
  set_tris_d(0b00000000);                                                     // RD[7..0]=Output
  
  delay_ms(500);
  printf("\n\n\n\r");
  printf("Demo ADC ET-BASE PIC40/46K22(ICSP)\n\r");
  printf("Run 64MHz(Internal 16MHz + PLL[4])\n\n\r");  
  
  while(true)
  { 
    set_adc_channel(0);                                                       // Select Channel AN0
    delay_us(10);                                                             // Wait Multiplex Stable     
    AN0_Value = read_adc();                                                   // Read adc channel 0 

    printf("ADC[0] : AN0 = %3u \r",AN0_Value);
    output_d(~LED[AN0_Value/32]);
    delay_ms(250);
  }  
}

