/************************************************/
/* Demo Program For ET-BASE PIC40/46K80(ICSP)   */
/* MCU Control : PIC18F46K80                    */
/*             : Run 64MHz(Internal 16MHz+4PLL) */
/* Compiler    : C18 Version 3.41               */
/* Function    : SW Control Toggle LED          */
/************************************************/

/** C O N F I G U R A T I O N   B I T S ******************************/
//ETT:ET-BASE PIC40/46K80(PIC18F46K80) 
#pragma config RETEN    = ON            // Ultra low-power regulator is Enabled (Controlled by SRETEN bit)
#pragma config INTOSCSEL = LOW          // LF-INTOSC in Low-power mode during Sleep
#pragma config SOSCSEL  = LOW           // Low Power SOSC circuit selected
#pragma config XINST    = OFF           // Disabled Extended Instruction Set
 
#pragma config FOSC     = INTIO1        // Internal RC oscillator, CLKOUT function on OSC2
#pragma config PLLCFG   = ON            // Oscillator multiplied by 4
#pragma config FCMEN    = ON            // Fail-Safe Clock Monitor enabled
#pragma config IESO     = ON            // Oscillator Switchover mode enabled
#pragma config PWRTEN   = ON          	// Power up timer enabled 
#pragma config BOREN    = SBORDIS       // Brown-out Reset enabled in hardware only (SBOREN is disabled)
#pragma config BORV     = 0             // VBOR set to 3.0V V nominal
#pragma config BORPWR   = LOW           // BORMV set to low power level
#pragma config WDTEN    = OFF           // Watch dog timer is always disabled. SWDTEN has no effect.
#pragma config WDTPS    = 1048576       // 1:1048576
#pragma config CANMX    = PORTB         // ECAN TX and RX pins are located on RB2 and RB3, respectively
#pragma config MSSPMSK  = MSK7          // 7 Bit address masking mode
#pragma config MCLRE    = ON            // MCLR Enabled, RG5 Disabled
#pragma config STVREN   = ON            // Enabled Stack Overflow Reset
#pragma config BBSIZ    = BB2K          // 2K word Boot Block size

//Disable All Protect
#pragma config CP0      = OFF           // Block 0 (000800-003FFFh) not code-protected
#pragma config CP1      = OFF           // Block 1 (004000-007FFFh) not code-protected
#pragma config CP2      = OFF           // Block 2 (008000-00BFFFh) not code-protected
#pragma config CP3      = OFF           // Block 3 (00C000-00FFFFh) not code-protected
#pragma config CPB      = OFF           // Boot block (000000-0007FFh) not code-protected
#pragma config CPD      = OFF           // Data EEPROM not code-protected
#pragma config WRT0     = OFF           // Block 0 (000800-003FFFh) not write-protected 
#pragma config WRT1     = OFF           // Block 1 (004000-007FFFh) not write-protected
#pragma config WRT2     = OFF           // Block 2 (008000-00BFFFh) not write-protected
#pragma config WRT3     = OFF           // Block 3 (00C000-00FFFFh) not write-protected
#pragma config WRTB     = OFF           // Boot Block (000000-0007FFh) not write-protected      
#pragma config WRTC     = OFF           // Configuration registers (300000-3000FFh) not write-protected
#pragma config WRTD     = OFF           // Data EEPROM not write-protected
#pragma config EBTR0    = OFF           // Block 0 (000800-003FFFh) not protected from table reads executed in other blocks
#pragma config EBTR1    = OFF           // Block 1 (004000-007FFFh) not protected from table reads executed in other blocks
#pragma config EBTR2    = OFF           // Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks
#pragma config EBTR3    = OFF           // Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks
#pragma config EBTRB    = OFF           // Boot Block (000000-0007FFh) not protected from table reads executed in other blocks
//ETT:ET-BASE PIC40/46K80(PIC18F46K80)

/** I N C L U D E S **************************************************/
#include "p18f46k80.h"
#include "GenericTypeDefs.h"
#include "delays.h"

/** POT(RA0)*******************************************************/
#define InitPOT()         {ANCON0bits.ANSEL0=1;TRISAbits.TRISA0=1;}

/** SWITCH(RA1)****************************************************/
#define InitSwitch1()     {ANCON0bits.ANSEL1=0;TRISAbits.TRISA1=1;}
#define sw1                PORTAbits.RA1
 
/** LED(RA2)*******************************************************/
#define InitLED1()        {ANCON0bits.ANSEL2=0;LATAbits.LATA2=0; TRISAbits.TRISA2=0;}	
#define LED1               LATAbits.LATA2    
#define LED1_On()          LED1 = 1;    
#define LED1_Off()         LED1 = 0;
#define LED1_Toggle()      LED1 = !LED1;

/** Run 64.00 MHz **************************************************/
#define CLOCK_FREQ 		   64000000   
#define GetSystemClock()   64000000

/** VARIABLES ******************************************************/
#pragma udata
BYTE old_sw1;

/** PRIVATE PROTOTYPES *********************************************/
BOOL Switch1IsPressed(void);

/** D E C L A R A T I O N S *******************************************/
#pragma code
void main (void)
{
  //Config PIC18F46K80 Oscillator : Run 64MHz from Internal 16MHz + PLL(4)
  OSCCONbits.IRCF = 7;					// HF-INTOSC output frequency is used (16 MHz)	
  OSCCONbits.OSTS = 0;					// Oscillator Start-up Timer (OST) time-out is running
  OSCCONbits.HFIOFS = 1;				// HF-INTOSC oscillator frequency is stable
  OSCCONbits.SCS = 0;					// HF-INTOSC with PLL. Defined by the FOSC<3:0> Configuration bits, CONFIG1H<3:0>.)
  OSCTUNEbits.PLLEN = 1;  				// x4 PLL enabled = 64MHz

  ANCON0bits.ANSEL2 = 0;                // RA2 = Digital 
  ANCON0bits.ANSEL1 = 0;                // RA1 = Digital 
  ANCON0bits.ANSEL0 = 1;				// RA0 = ADC

  InitLED1();							// Initial LED = Output
  InitSwitch1();						// Initial SW1 = Input
  old_sw1 = 1;							// Default SW1 = Release
  LED1_On();							// Default LED1 = ON

  while (1)
  {
    if(Switch1IsPressed())				// SW Press Toggle LED
    {
      LED1_Toggle();					// Toggle LED
    }
  }	
}

/******************************************************************************
 * Function:        BOOL Switch1IsPressed(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          TRUE - pressed, FALSE - not pressed
 *
 * Side Effects:    None
 *
 * Overview:        Indicates if the switch is pressed.  
 *
 * Note:            
 *
 *****************************************************************************/
BOOL Switch1IsPressed(void)
{
  if(sw1 != old_sw1)
  {
    Delay10TCYx(250);      				// debounce 2500 cycles 
    if(sw1 != old_sw1) 
    {
      old_sw1 = sw1;                  	// Save new value
      if(sw1 == 0)                    	// If pressed
      return TRUE;                		// Was pressed
    }
  }//end if

  return FALSE;                     	// Was not pressed
}//end Switch1IsPressed
