/************************************************/
/* Demo Program For ET-BASE PIC40/46K22(ICSP)   */
/* MCU Control : PIC18F46K22                    */
/*             : Run 64MHz(Internal 16MHz+4PLL) */
/* Compiler    : C18 Version 3.41               */
/* Function    : SW Control Toggle LED          */
/************************************************/

/** C O N F I G U R A T I O N   B I T S ******************************/
//ETT:ET-BASE PIC40/46K22(PIC18F46K22) 
#pragma config FOSC     = INTIO7        // Internal oscillator block, CLKOUT function on OSC2
#pragma config PLLCFG   = ON          	// Oscillator multiplied by 4
#pragma config PRICLKEN = ON        	// Primary clock is always enabled
#pragma config FCMEN    = ON            // Fail-Safe Clock Monitor enabled
#pragma config IESO     = ON            // Oscillator Switchover mode enabled
#pragma config PWRTEN   = ON          	// Power up timer enabled 
#pragma config BOREN    = SBORDIS       // Brown-out Reset enabled in hardware only (SBOREN is disabled)
#pragma config BORV     = 285           // VBOR set to 2.85 V nominal
#pragma config WDTEN    = OFF           // Watch dog timer is always disabled. SWDTEN has no effect.
#pragma config WDTPS    = 32768         // 1:32768
#pragma config CCP2MX   = PORTB3        // CCP2 input/output is multiplexed with RB3
#pragma config PBADEN   = OFF           // PORTB<5:0> pins are configured as digital I/O on Reset
#pragma config CCP3MX   = PORTB5        // P3A/CCP3 input/output is multiplexed with RB5
#pragma config HFOFST   = OFF           // HFINTOSC output and ready status are delayed by the oscillator stable status
#pragma config T3CMX    = PORTB5        // T3CKI is on RB5 
#pragma config P2BMX    = PORTD2        // P2B is on RD2
#pragma config MCLRE    = EXTMCLR       // MCLR pin enabled, RE3 input pin disabled 
#pragma config LVP      = ON            // Single-Supply ICSP enabled if MCLRE is also 1
#pragma config XINST    = OFF           // Instruction set extension and Indexed Addressing mode disabled (Legacy mode)
#pragma config DEBUG    = ON            // Enabled

//Disable All Protect
#pragma config CP0      = OFF           // Block 0 (000800-003FFFh) not code-protected
#pragma config CP1      = OFF           // Block 1 (004000-007FFFh) not code-protected
#pragma config CP2      = OFF           // Block 2 (008000-00BFFFh) not code-protected
#pragma config CP3      = OFF           // Block 3 (00C000-00FFFFh) not code-protected
#pragma config CPB      = OFF           // Boot block (000000-0007FFh) not code-protected
#pragma config CPD      = OFF           // Data EEPROM not code-protected
#pragma config WRT0     = OFF           // Block 0 (000800-003FFFh) not write-protected 
#pragma config WRT1     = OFF           // Block 1 (004000-007FFFh) not write-protected
#pragma config WRT2     = OFF           // Block 2 (008000-00BFFFh) not write-protected
#pragma config WRT3     = OFF           // Block 3 (00C000-00FFFFh) not write-protected
#pragma config WRTB     = OFF           // Boot Block (000000-0007FFh) not write-protected      
#pragma config WRTC     = OFF           // Configuration registers (300000-3000FFh) not write-protected
#pragma config WRTD     = OFF           // Data EEPROM not write-protected
#pragma config EBTR0    = OFF           // Block 0 (000800-003FFFh) not protected from table reads executed in other blocks
#pragma config EBTR1    = OFF           // Block 1 (004000-007FFFh) not protected from table reads executed in other blocks
#pragma config EBTR2    = OFF           // Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks
#pragma config EBTR3    = OFF           // Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks
#pragma config EBTRB    = OFF           // Boot Block (000000-0007FFh) not protected from table reads executed in other blocks
//ETT:ET-BASE PIC40/46K22(PIC18F46K22)

/** I N C L U D E S **************************************************/
#include "p18f46k22.h"
#include "GenericTypeDefs.h"
#include "delays.h"

/** POT(RA0)*******************************************************/
#define InitPOT()         {ANSELAbits.ANSA0=1;TRISAbits.TRISA0=1;}

/** SWITCH(RA1)****************************************************/
#define InitSwitch1()     {ANSELAbits.ANSA1=0;TRISAbits.TRISA1=1;}
#define sw1                PORTAbits.RA1
 
/** LED(RA2)*******************************************************/
#define InitLED1()        {ANSELAbits.ANSA2=0;LATAbits.LATA2=0; TRISAbits.TRISA2=0;}	
#define LED1               LATAbits.LATA2    
#define LED1_On()          LED1 = 1;    
#define LED1_Off()         LED1 = 0;
#define LED1_Toggle()      LED1 = !LED1;

/** Run 64.00 MHz **************************************************/
#define CLOCK_FREQ 		   64000000   
#define GetSystemClock()   64000000

/** VARIABLES ******************************************************/
#pragma udata
BYTE old_sw1;

/** PRIVATE PROTOTYPES *********************************************/
BOOL Switch1IsPressed(void);

/** D E C L A R A T I O N S *******************************************/
#pragma code
void main (void)
{
  //Config PIC18F46K22 Oscillator : Run 64MHz from Internal 16MHz + PLL(4)
  OSCCONbits.IRCF = 7;					// Internal RC Oscillator Frequency = HFINTOSC  (16 MHz)
  OSCCONbits.OSTS = 0;					// Oscillator Start-up Time-out = Device is running from the internal oscillator (HFINTOSC, MFINTOSC or LFINTOSC)
  OSCCONbits.HFIOFS = 1;				// HFINTOSC frequency is stable
  OSCCONbits.SCS = 0;					// Primary clock (determined by FOSC<3:0> in CONFIG1H).
  OSCTUNEbits.PLLEN = 1;  				// x4 PLL enabled = 64MHz

  ANSELAbits.ANSA2 = 0;					// RA2 = Digital
  ANSELAbits.ANSA1 = 0; 				// RA1 = Digital
  ANSELAbits.ANSA0 = 1;					// RA0 = Analog

  InitLED1();							// Initial LED = Output
  InitSwitch1();						// Initial SW1 = Input
  old_sw1 = 1;							// Default SW1 = Release
  LED1_On();							// Default LED1 = ON

  while (1)
  {
    if(Switch1IsPressed())				// SW Press Toggle LED
    {
      LED1_Toggle();					// Toggle LED
    }
  }	
}

/******************************************************************************
 * Function:        BOOL Switch1IsPressed(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          TRUE - pressed, FALSE - not pressed
 *
 * Side Effects:    None
 *
 * Overview:        Indicates if the switch is pressed.  
 *
 * Note:            
 *
 *****************************************************************************/
BOOL Switch1IsPressed(void)
{
  if(sw1 != old_sw1)
  {
    Delay10TCYx(250);      				// debounce 2500 cycles 
    if(sw1 != old_sw1) 
    {
      old_sw1 = sw1;                  	// Save new value
      if(sw1 == 0)                    	// If pressed
      return TRUE;                		// Was pressed
    }
  }//end if

  return FALSE;                     	// Was not pressed
}//end Switch1IsPressed

