VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form MainForm 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "HID Demo ET-BASE PIC18F4550"
   ClientHeight    =   3540
   ClientLeft      =   5490
   ClientTop       =   4080
   ClientWidth     =   3930
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3540
   ScaleWidth      =   3930
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer Timer1 
      Interval        =   250
      Left            =   2280
      Top             =   2040
   End
   Begin MSComctlLib.ProgressBar ADC 
      Height          =   495
      Left            =   1560
      TabIndex        =   1
      Top             =   2880
      Width           =   2055
      _ExtentX        =   3625
      _ExtentY        =   873
      _Version        =   393216
      Appearance      =   1
      Enabled         =   0   'False
      Max             =   255
   End
   Begin VB.CommandButton LEDCommand 
      Caption         =   "LED Control"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1560
      TabIndex        =   0
      Top             =   840
      Width           =   2055
   End
   Begin VB.Label Label3 
      Caption         =   "ADC:RA[0]"
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   3000
      Width           =   1335
   End
   Begin VB.Label Label2 
      Caption         =   "SW1:RA[1]"
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   2160
      Width           =   1335
   End
   Begin VB.Label Label1 
      Caption         =   "LED:RA[2]"
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   960
      Width           =   1215
   End
   Begin VB.Shape LED 
      FillColor       =   &H00E0E0E0&
      FillStyle       =   0  'Solid
      Height          =   495
      Left            =   2280
      Shape           =   3  'Circle
      Top             =   240
      Width           =   615
   End
   Begin VB.Shape SW1 
      FillColor       =   &H00E0E0E0&
      FillStyle       =   0  'Solid
      Height          =   495
      Left            =   1560
      Top             =   2040
      Width           =   2055
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Const InputON = &HFF00&                                 ' Green Color
Const InputOFF = &H80000004                             ' Menu Color
Const OutputON = &HFF&                                  ' Red Color
Const OutputOFF = &HFFFFF8                              ' Menu Color

' vendor and product IDs
Private Const VendorID = 6017
Private Const ProductID = 2000

' read and write buffers
Private Const BufferInSize = 3
Private Const BufferOutSize = 3
Dim BufferIn(0 To BufferInSize) As Byte
Dim BufferOut(0 To BufferOutSize) As Byte

' ****************************************************************
' when the form loads, connect to the HID controller - pass
' the form window handle so that you can receive notification
' events...
'*****************************************************************
Private Sub Form_Load()

  ADC.Value = 0
  SW1.FillColor = InputOFF
  LED.FillColor = OutputOFF
  ADC.Enabled = False
  LEDCommand.Enabled = False
    
  ' do not remove!
  ConnectToHID (Me.hwnd)
  
End Sub

'*****************************************************************
' disconnect from the HID controller...
'*****************************************************************
Private Sub Form_Unload(Cancel As Integer)

   DisconnectFromHID
   
End Sub

'*****************************************************************
' a HID device has been plugged in...
'*****************************************************************
Public Sub OnPlugged(ByVal pHandle As Long)
   If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then
   
     ' ** YOUR CODE HERE **
     ADC.Enabled = True
     LEDCommand.Enabled = True
     
   End If
End Sub

'*****************************************************************
' a HID device has been unplugged...
'*****************************************************************
Public Sub OnUnplugged(ByVal pHandle As Long)
   If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then
   
     ' ** YOUR CODE HERE **
     SW1.FillColor = InputOFF
     LED.FillColor = OutputOFF
     
     ADC.Enabled = False
     LEDCommand.Enabled = False
     
   End If
End Sub

'*****************************************************************
' controller changed notification - called
' after ALL HID devices are plugged or unplugged
'*****************************************************************
Public Sub OnChanged()

   Dim DeviceHandle As Long
   
   ' get the handle of the device we are interested in, then set
   ' its read notify flag to true - this ensures you get a read
   ' notification message when there is some data to read...
   DeviceHandle = hidGetHandle(VendorID, ProductID)
   hidSetReadNotify DeviceHandle, True
   
End Sub

'*****************************************************************
' on read event...
'*****************************************************************
Public Sub OnRead(ByVal pHandle As Long)
   
   ' read the data (don't forget, pass the whole array)...
   If hidRead(pHandle, BufferIn(0)) Then
   
     ' first byte is the report ID, e.g. BufferIn(0)
     ' the other bytes are the data from the microcontrolller...
     ' ** YOUR CODE HERE **
     
     '1st Byte Data = ADC(0..255) Value
     ADC.Value = BufferIn(1)
   
     '2nd Byte Data = SW1(0,1) Value
     If BufferIn(2) = 0 Then
       SW1.FillColor = InputON
     Else
       SW1.FillColor = InputOFF
     End If
                
   End If
   
End Sub

'*****************************************************************
' this is how you write some data...
'*****************************************************************
Public Sub WriteSomeData()

   BufferOut(0) = 0   ' first by is always the report ID
   BufferOut(1) = 10  ' first data item, etc etc

   ' write the data (don't forget, pass the whole array)...
   hidWriteEx VendorID, ProductID, BufferOut(0)
   
End Sub

'**************************
'* Send Toggle ON/OFF LED *
'**************************
Private Sub LEDCommand_Click()

  BufferOut(0) = 0                      'first by is always the report ID
    
  If LED.FillColor = OutputOFF Then
     LED.FillColor = OutputON
     BufferOut(3) = 1                   'Data ON LED
  Else
     LED.FillColor = OutputOFF
     BufferOut(3) = 0                   'Data OFF LED
  End If
  
  ' write the data (don't forget, pass the whole array)...
  hidWriteEx VendorID, ProductID, BufferOut(0)
   
End Sub

'250mS Trigger Update USB Data
Private Sub Timer1_Timer()
  
  BufferOut(0) = 0                      'first by is always the report ID
  
  'Refresh LED Status to Controller
  If LED.FillColor = OutputOFF Then
     BufferOut(3) = 0                   'Data OFF LED
  Else
     BufferOut(3) = 1                   'Data ON LED
  End If
  
  ' write the data (don't forget, pass the whole array)...
  hidWriteEx VendorID, ProductID, BufferOut(0)
   
End Sub
