
; PICBASIC PRO(TM) Compiler 2.60A, (c) 1998, 2010 microEngineering Labs, Inc. All Rights Reserved. 
_USED			EQU	1

	INCLUDE	"C:\PBP\18F4550.INC"


; Define statements.
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00040	DEFINE OSC 48          
#define		OSC		 48          
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00041	DEFINE LOADER_USED 1
#define		LOADER_USED		 1
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00066	DEFINE ADC_BITS 8                               'Set number of bits in result
#define		ADC_BITS		 8                               
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00067	DEFINE ADC_CLOCK 3                              'Set clock source (rc = 3)
#define		ADC_CLOCK		 3                              
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00068	DEFINE ADC_SAMPLEUS 50                          'Set sampling time in microseconds 
#define		ADC_SAMPLEUS		 50                          

RAM_START       		EQU	00000h
RAM_END         		EQU	003FFh
RAM_BANKS       		EQU	00004h
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

; C:\PBP\PBPPIC18.RAM      	00028	A00000	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP\PBPPIC18.RAM      	00012	A00001	R0      VAR     WORD BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 001h
; C:\PBP\PBPPIC18.RAM      	00013	A00003	R1      VAR     WORD BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 003h
; C:\PBP\PBPPIC18.RAM      	00014	A00005	R2      VAR     WORD BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 005h
; C:\PBP\PBPPIC18.RAM      	00015	A00007	R3      VAR     WORD BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 007h
; C:\PBP\PBPPIC18.RAM      	00016	A00009	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 009h
; C:\PBP\PBPPIC18.RAM      	00017	A0000B	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Bh
; C:\PBP\PBPPIC18.RAM      	00018	A0000D	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Dh
; C:\PBP\PBPPIC18.RAM      	00019	A0000F	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 00Fh
; C:\PBP\PBPPIC18.RAM      	00020	A00011	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 011h
; C:\PBP\PBPPIC18.RAM      	00027	A00013	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 013h
; C:\PBP\PBPPIC18.RAM      	00023	A00014	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 014h
; C:\PBP\PBPPIC18.RAM      	00026	A00015	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 015h
; C:\PBP\PBPPIC18.RAM      	00021	A00016	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 016h
; C:\PBP\PBPPIC18.RAM      	00024	A00017	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 017h
; C:\PBP\PBPPIC18.RAM      	00022	A00018	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 018h
; C:\PBP\PBPPIC18.RAM      	00025	A00019	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 019h
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00053	A0001A	USBBufferCount   Var Byte 
_USBBufferCount  		EQU	RAM_START + 01Ah
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00052	A0001B	USBBuffer        Var Byte[USBBufferSizeMax] 
_USBBuffer       		EQU	RAM_START + 01Bh
; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00027	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00028	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00029	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00030	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC
#define _VR1             	_PORTA??0
#define _SW1             	_PORTA??1
#define _LED             	_PORTA??2
#define _PORTA??0        	 PORTA, 000h
#define _TRISA??0        	 TRISA, 000h
#define _PORTA??1        	 PORTA, 001h
#define _TRISA??1        	 TRISA, 001h
#define _PORTA??2        	 PORTA, 002h
#define _TRISA??2        	 TRISA, 002h
#define _ADCON0??1       	 ADCON0, 001h

; Constants.
_USBBufferSizeMax		EQU	00003h
_USBBufferSizeTX 		EQU	00003h
_USBBufferSizeRX 		EQU	00003h

; EEPROM data.


	INCLUDE	"DEMO_P~1.MAC"
	INCLUDE	"C:\PBP\PBPUSB18.LIB"


; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00012	BANKA   $0000, $005F
; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00013	BANK0   $0060, $00FF
; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00014	BANK1   $0100, $01FF
; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00015	BANK2   $0200, $02FF
; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00016	BANK3   $0300, $03FF
; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00023	LIBRARY "PBPUSB18"

; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00025	        include "PIC18EXT.BAS"

; C:\PIC18F~1\PICBAS~1\18F4550.BAS	00032	        include "PBPPIC18.RAM"
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00040	DEFINE OSC 48          
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00041	DEFINE LOADER_USED 1
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00047	USBBufferSizeMax   con 3                        'maximum buffer size
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00048	USBBufferSizeTX    con 3                        'input 
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00049	USBBufferSizeRX    con 3                        'output

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00061	usbinit ' initialise USB...
	USBINIT?	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00065	TRISA.0 = 1                                     'ADC=Input
	MOVE?CT	001h, _TRISA??0
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00066	DEFINE ADC_BITS 8                               'Set number of bits in result
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00067	DEFINE ADC_CLOCK 3                              'Set clock source (rc = 3)
; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00068	DEFINE ADC_SAMPLEUS 50                          'Set sampling time in microseconds 

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00069	ADCON1 = %00001110                              'Only PORTA.0 is analog input 
	MOVE?CB	00Eh, ADCON1

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00072	TRISA.1 = 1                                     'SW1=Input
	MOVE?CT	001h, _TRISA??1

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00075	TRISA.2 = 0                                     'LED=Output
	MOVE?CT	000h, _TRISA??2

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00076	HIGH LED                                        'Default LED = ON
	HIGH?T	_LED

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00079	ProgramStart: 

	LABEL?L	_ProgramStart	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00082	   ADCIN 0, USBBuffer[0]                        'Read channel 0 to USBBuffer[0]
	ADCIN?CB	000h, _USBBuffer

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00083	   while  ADCON0.1                              'Wait for conversation completed
	LABEL?L	L00001	
	CMPF?TL	_ADCON0??1, L00002

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00084	   wend 
	GOTO?L	L00001
	LABEL?L	L00002	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00087	   if SW1 == 0 Then
	CMPNE?TCL	_SW1, 000h, L00003

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00088	     USBBuffer[1] = 0
	MOVE?CB	000h, _USBBuffer + 00001h

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00089	   else
	GOTO?L	L00004
	LABEL?L	L00003	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00090	     USBBuffer[1] = 1      
	MOVE?CB	001h, _USBBuffer + 00001h

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00091	   endif
	LABEL?L	L00004	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00093	   gosub DoUSBOut
	GOSUB?L	_DoUSBOut

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00096	   gosub DoUSBIn   
	GOSUB?L	_DoUSBIn

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00098	   if usbbuffer[2] = 0 then
	CMPNE?BCL	_USBBuffer + 00002h, 000h, L00005

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00099	     low led
	LOW?T	_LED

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00100	   else 
	GOTO?L	L00006
	LABEL?L	L00005	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00101	     high led
	HIGH?T	_LED

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00102	   endif
	LABEL?L	L00006	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00104	   goto ProgramStart  
	GOTO?L	_ProgramStart

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00109	DoUSBIn:

	LABEL?L	_DoUSBIn	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00110	   USBBufferCount = USBBufferSizeRX              'RX buffer size
	MOVE?CB	_USBBufferSizeRX, _USBBufferCount

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00111	   USBService                                    'keep connection alive
	USBSERVICE?	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00112	   USBIn 1, USBBuffer, USBBufferCount, DoUSBIn   'read data, if available
	USBIN?CBBL	001h, _USBBuffer, _USBBufferCount, _DoUSBIn

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00113	   return
	RETURN?	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00118	DoUSBOut:

	LABEL?L	_DoUSBOut	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00119	   USBBufferCount = USBBufferSizeTX              'TX buffer size
	MOVE?CB	_USBBufferSizeTX, _USBBufferCount

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00120	   USBService                                    'keep connection alive
	USBSERVICE?	

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00121	   USBOut 1, USBBuffer, USBBufferCount, DoUSBOut 'if bus available, transmit data
	USBOUT?CBBL	001h, _USBBuffer, _USBBufferCount, _DoUSBOut

; C:\PIC18F~1\PICBAS~1\DEMO_P~1.PBP	00122	   return
	RETURN?	

	END
