/*************************************************/
/* Demo Program For ET-BASE PIC40/4550(ICSP)     */
/* MCU Control : PIC18F4550                      */
/*             : Run 48MHz(X-TAL 8.00 MHz + PLL) */
/* Compiler    : PIC-CCS Version 4.120           */
/* Function    : Demo UART1(RS232) Echo Test     */
/*************************************************/
#include <18F4550.h>
#include <stdlib.h>

// Fuses: PIC18F4550(CCS Compiler)
//////// Fuses: PLL1,PLL2,PLL3,PLL4,PLL5,PLL6,PLL10,PLL12,CPUDIV1,CPUDIV2
//////// Fuses: CPUDIV3,CPUDIV4,NOUSBDIV,USBDIV,XT,XTPLL,EC_IO,EC,ECPLL_IO
//////// Fuses: ECPLL,INTEC_IO,INTEC,INTXT,INTHS,HS,HSPLL,NOFCMEN,FCMEN
//////// Fuses: NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW,BROWNOUT_NOSL
//////// Fuses: BROWNOUT,BORV45,BORV43,BORV27,BORV20,NOVREGEN,VREGEN,NOWDT
//////// Fuses: WDT,WDT1,WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128,WDT256
//////// Fuses: WDT512,WDT1024,WDT2048,WDT4096,WDT8192,WDT16384,WDT32768
//////// Fuses: CCP2B3,CCP2C1,NOPBADEN,PBADEN,NOLPT1OSC,LPT1OSC,NOMCLR,MCLR
//////// Fuses: NOSTVREN,STVREN,NOLVP,LVP,ICSP1,ICSP2,NOXINST,XINST,DEBUG
//////// Fuses: NODEBUG,PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC
//////// Fuses: NOWRTC,WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = X-TAL
//if used XTAL=8MHz -> 8MHz/2=4MHz -> 4MHzxPLL(96MHz)/2=48MHz
#fuses HSPLL,NOWDT,NOPROTECT,NOLVP,NODEBUG,USBDIV,PLL2,CPUDIV1,VREGEN         //XTAL-8MHz+PLL=48MHz 
#use delay(clock=48000000)

/* Config and Enable Hardware UART1(RC6=TX1,RC7=RX1 */
#use rs232(uart1, baud=9600, stream=CH1)

/* Config and Enable Software UART2(RC0=TX2,RC1=RX2 */
#define TX2 PIN_C0                                                            // RC0 = TXD
#define RX2 PIN_C1                                                            // RC1 = RXD
#use rs232(baud=9600, xmit=TX2, rcv=RX2,stream=CH2)

/****************/
/* Main Program */
/****************/
void main() 
{  
  char rx_buff;
  
  
  delay_ms(500);
  
  //Start-Up UART1
  fprintf(CH1,"\n\n\n\r");
  fprintf(CH1,"Demo UART1 ET-BASE PIC40/4550(ICSP)\n\r");
  fprintf(CH1,"Run 48.00 MHz(Crystal 8 MHz + PLL)\n\r");  
  fprintf(CH1,"UART1>");
  
  //Start-Up UART2
  fprintf(CH2,"\n\n\n\r");
  fprintf(CH2,"Demo UART2 ET-BASE PIC40/4550(ICSP)\n\r");
  fprintf(CH2,"Run 48.00 MHz(Crystal 8 MHz + PLL)\n\r");  
  fprintf(CH2,"UART2>");
  
  while(true)
  { 
    //Verify & Echo UART1
    if(kbhit(CH1))
    {
      rx_buff = fgetc(CH1);
      if (rx_buff == 0x0D)
      {
        fprintf(CH1,"\n\r");
        fprintf(CH1,"ET-BASE PIC40/4550(ICSP)\n\r");
        fprintf(CH1,"UART1>");
      }
      else 
      {
        fputc(rx_buff,CH1);                                                   // Echo Received Characters      
      }
    }  
    
    //Verify & Echo UART2
    if(kbhit(CH2))
    {
      rx_buff = fgetc(CH2);
      if (rx_buff == 0x0D)
      {
        fprintf(CH2,"\n\r");
        fprintf(CH2,"ET-BASE PIC40/4550(ICSP)\n\r");
        fprintf(CH2,"UART2>");
      }
      else 
      {
        fputc(rx_buff,CH2);                                                   // Echo Received Characters      
      }
    }  
  }  
}

