/************************************************/
/* Demo Program For ET-BASE PIC40/4550(ICSP)    */
/* MCU Control : PIC18F4550                     */
/*             : Run 48MHz(X-TAL 8.00MHz + PLL) */
/* Compiler    : PIC-CCS Version 4.120          */
/* Function    : Demo All GPIO Output Demo Test */
/************************************************/

#include <18F4550.h>
#include <stdlib.h>

// Fuses: PIC18F4550(CCS Compiler)
//////// Fuses: PLL1,PLL2,PLL3,PLL4,PLL5,PLL6,PLL10,PLL12,CPUDIV1,CPUDIV2
//////// Fuses: CPUDIV3,CPUDIV4,NOUSBDIV,USBDIV,XT,XTPLL,EC_IO,EC,ECPLL_IO
//////// Fuses: ECPLL,INTEC_IO,INTEC,INTXT,INTHS,HS,HSPLL,NOFCMEN,FCMEN
//////// Fuses: NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW,BROWNOUT_NOSL
//////// Fuses: BROWNOUT,BORV45,BORV43,BORV27,BORV20,NOVREGEN,VREGEN,NOWDT
//////// Fuses: WDT,WDT1,WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128,WDT256
//////// Fuses: WDT512,WDT1024,WDT2048,WDT4096,WDT8192,WDT16384,WDT32768
//////// Fuses: CCP2B3,CCP2C1,NOPBADEN,PBADEN,NOLPT1OSC,LPT1OSC,NOMCLR,MCLR
//////// Fuses: NOSTVREN,STVREN,NOLVP,LVP,ICSP1,ICSP2,NOXINST,XINST,DEBUG
//////// Fuses: NODEBUG,PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC
//////// Fuses: NOWRTC,WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = X-TAL
//if used XTAL=8MHz -> 8MHz/2=4MHz -> 4MHzxPLL(96MHz)/2=48MHz
#fuses HSPLL,NOWDT,NOPROTECT,NOLVP,NODEBUG,USBDIV,PLL2,CPUDIV1,VREGEN         //XTAL-8MHz+PLL=48MHz 
#use delay(clock=48000000)

const unsigned char LED[8] =
{
  0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80                              // 8 Bit LED Test
};
 
/****************/
/* Main Program */
/****************/
void main() 
{
  unsigned char count;
  
  set_tris_a(0b11000000);                                                     // RA[5..0]=Output
  set_tris_b(0b00000000);                                                     // RB[7..0]=Output
  set_tris_c(0b00111000);                                                     // RC[7..6,2..0]=Output
  set_tris_d(0b00000000);                                                     // RD[7..0]=Output
  set_tris_e(0b11111000);                                                     // RE[2..0]=Output
                        
  while(true)
  {    
    for(count = 0; count < 8; count++)                                        // 8 Bit LED 
    {    
      output_a(~LED[count]);    
      output_b(~LED[count]);
      output_c(~LED[count]);
      output_d(~LED[count]);
      output_e(~LED[count]);
      delay_ms(500);                             
    }  
  }
}  

