/************************************************/
/* Demo Program For ET-BASE PIC40/4550(ICSP)    */
/* MCU Control : PIC18F4550                     */
/*             : Run 48MHz(X-TAL 8.00MHz + PLL) */
/* Compiler    : PIC-CCS Version 4.120          */
/* Function    : Demo ADC Display UART1(RS232)  */
/************************************************/
#include <18F4550.h>
#include <stdlib.h>

// Fuses: PIC18F4550(CCS Compiler)
//////// Fuses: PLL1,PLL2,PLL3,PLL4,PLL5,PLL6,PLL10,PLL12,CPUDIV1,CPUDIV2
//////// Fuses: CPUDIV3,CPUDIV4,NOUSBDIV,USBDIV,XT,XTPLL,EC_IO,EC,ECPLL_IO
//////// Fuses: ECPLL,INTEC_IO,INTEC,INTXT,INTHS,HS,HSPLL,NOFCMEN,FCMEN
//////// Fuses: NOIESO,IESO,PUT,NOPUT,NOBROWNOUT,BROWNOUT_SW,BROWNOUT_NOSL
//////// Fuses: BROWNOUT,BORV45,BORV43,BORV27,BORV20,NOVREGEN,VREGEN,NOWDT
//////// Fuses: WDT,WDT1,WDT2,WDT4,WDT8,WDT16,WDT32,WDT64,WDT128,WDT256
//////// Fuses: WDT512,WDT1024,WDT2048,WDT4096,WDT8192,WDT16384,WDT32768
//////// Fuses: CCP2B3,CCP2C1,NOPBADEN,PBADEN,NOLPT1OSC,LPT1OSC,NOMCLR,MCLR
//////// Fuses: NOSTVREN,STVREN,NOLVP,LVP,ICSP1,ICSP2,NOXINST,XINST,DEBUG
//////// Fuses: NODEBUG,PROTECT,NOPROTECT,CPB,NOCPB,CPD,NOCPD,WRT,NOWRT,WRTC
//////// Fuses: NOWRTC,WRTB,NOWRTB,WRTD,NOWRTD,EBTR,NOEBTR,EBTRB,NOEBTRB

//Select Jumper RA6,RA7(XTAL/GPIO) = X-TAL
//if used XTAL=8MHz -> 8MHz/2=4MHz -> 4MHzxPLL(96MHz)/2=48MHz
#fuses HSPLL,NOWDT,NOPROTECT,NOLVP,NODEBUG,USBDIV,PLL2,CPUDIV1,VREGEN         //XTAL-8MHz+PLL=48MHz 
#use delay(clock=48000000)

/* Config and Enable Hardware UART1(RC6=TX1,RC7=RX1 */
#use rs232(uart1, baud=9600)

//ADC0:RA0:VR1 -> Demo Test ADC
#define ADC0_PIN    PIN_A0                                                    //ADC0(VR1)

//LED Barfraph Display Scale ADC Result
const unsigned char LED[8] =
{
  0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF                              // 8 Bit LED Test
};

/****************/
/* Main Program */
/****************/
void main() 
{ 
  int8 AN0_Value;
  
  setup_oscillator(OSC_8MHZ|OSC_PLL_ON);                                      //Sets the Internal Oscillator to 32MHz (PLL Enabled)  
  delay_ms(500);
  output_float(ADC0_PIN);                                                     // ADC Input
  setup_adc_ports(AN0);                                                       // Assign Analog pin
  setup_adc(ADC_CLOCK_INTERNAL);                                      
  
  //Used RD[7..0]= Bargraph Display
  set_tris_d(0b00000000);                                                     // RD[7..0]=Output
  
  printf("\n\n\n\r");
  printf("Demo ADC ET-BASE PIC40/4550(ICSP)\n\r");
  printf("Run 48MHz(Crystal 8.00 MHz + PLL)\n\n\r");  
  
  while(true)
  { 
    set_adc_channel(0);                                                       // Select Channel AN0
    delay_us(10);                                                             // Wait Multiplex Stable     
    AN0_Value = read_adc();                                                   // Read adc channel 0 

    printf("ADC[0] : AN0 = %3u \r",AN0_Value);
    output_d(~LED[AN0_Value/32]);
    delay_ms(250);
  }  
}

