/***********************************************/
/* Demo Program For ET-BASE PIC40/1939(ICSP)   */
/* MCU Control : PIC16F1939                    */
/*             : Run 32MHz(Internal 8MHz+4PLL) */
/* Compiler    : Hitech C Version 9.83         */
/* Function    : SW Control Toggle LED         */
/***********************************************/
#include <htc.h>					// Required to interface with delay routines

//Config Run Internal Oscillator 32MHz (Internal 8MHz + 4xPLL)
__CONFIG(FOSC_INTOSC & 				// FOSC = Internal Oscillator
         WDTE_OFF &					// WDT disabled
         PWRTE_ON &     			// Power-up Timer Enable
         MCLRE_ON &					// MCLR pin function is MCLR
         CP_OFF &					// Code Protection Disable
         CPD_OFF &					// Data Protection Disable
         BOREN_OFF &				// Brown-out Reset Disable
         CLKOUTEN_OFF &				// CLKOUT Function Disabled
         IESO_ON &					// Internal/External Switchover mode is enabled
         FCMEN_ON &					// Fail-Safe Clock Monitor is enabled

         //Config2
         WRT_OFF &      			// Write protection off
         VCAPEN_OFF &   			// No capacitor on VCAP pin
         PLLEN_ON &					// 4x PLL enabled
         STVREN_ON &				// Stack Overflow or Underflow will cause a Reset
         BORV_HI &    				// Brown-out Reset Voltage (VBOR) set to 2.5 V       
         LVP_OFF);					// Low-voltage programming Disable        
#define  _XTAL_FREQ 	32000000	// Run 32.00 MHz

/** VR1(RA0): Analog Input ****************************************/
#define InitVR1()         	{ANSELAbits.ANSA0=1;TRISAbits.TRISA0=1;}

/** SW1(RA1): Digital Input ***************************************/
#define InitSW1()     		{ANSELAbits.ANSA1=0;TRISAbits.TRISA1=1;}
#define sw1                	PORTAbits.RA1

/** LED(RA2): Digital Output **************************************/
#define InitLED1()        	{ANSELAbits.ANSA2=0;LATAbits.LATA2=0; TRISAbits.TRISA2=0;}	
#define LED1               	LATAbits.LATA2    
#define LED1_TRIS			TRISA2
#define LED1_On()         	LED1 = 1;    
#define LED1_Off()         	LED1 = 0;
#define LED1_Toggle()      	LED1 = !LED1;

/** RS232(Hardware UART1)*******************************************/
#define UART1_TRISTx   	  	TRISCbits.TRISC6
#define UART1_Tx       	   	PORTCbits.RC6 
#define UART1_TRISRx   	   	TRISCbits.TRISC7
#define UART1_Rx       	   	PORTCbits.RC7    

/** VARIABLES ******************************************************/
unsigned char old_sw1;

/** PRIVATE PROTOTYPES *********************************************/
char Switch1IsPressed(void);

/** demonstration of various built-in delay mechanisms */
void main(void)
{
  unsigned char delay_led;

  //Config PIC16F1939 Oscillator : Run 32MHz from Internal 8MHz + PLL(4)
  OSCCONbits.SPLLEN = 1;				// 4x PLL is always enabled
  OSCCONbits.IRCF = 14;					// Internal Oscillator Frequency = 8MHz HF
  OSCCONbits.SCS = 0;					// HF-INTOSC with PLL. Defined by the FOSC<3:0> Configuration bits, CONFIG1H<3:0>.)
  OSCTUNEbits.TUN = 0;  				// Factory-calibrated frequency 

  InitVR1(); 							// VR1 = Analog Input
  InitSW1(); 							// SW1 = Digital Input
  InitLED1();							// LED = Digital Output

  old_sw1 = 1;							// Default SW1 = Release
  LED1_On();							// Default LED1 = ON

  while (1)
  {
    if(Switch1IsPressed())				// SW Press Toggle LED
    {
      LED1_Toggle();					// Toggle LED
    }
  }	
}

/******************************************************************************
 * Function:        BOOL Switch1IsPressed(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          TRUE - pressed, FALSE - not pressed
 *
 * Side Effects:    None
 *
 * Overview:        Indicates if the switch is pressed.  
 *
 * Note:            
 *
 *****************************************************************************/
char Switch1IsPressed(void)
{
  if(sw1 != old_sw1)
  {
    _delay(2500);      					// debounce 2500 cycles 
    if(sw1 != old_sw1) 
    {
      old_sw1 = sw1;                  	// Save new value
      if(sw1 == 0)                    	// If pressed
      return 1;                			// Was pressed
    }
  }//end if

  return 0;                     		// Was not pressed
}//end Switch1IsPressed
