/************************************************/
/* Demo Program For ET-BASE PIC40/1939(ICSP)    */
/* MCU Control : PIC16F1939                     */
/*             : Run 32MHz(Internal 8MHz + PLL) */
/* Compiler    : PIC-CCS Version 4.120          */
/* Function    : Demo UART1,UART2 Echo Test     */
/************************************************/
#include <16F1939.h>
#include <stdlib.h>

// Fuses: PIC16F1939(CCS Compiler)
// Fuses: LP,XT,HS,RC,INTRC_IO,ECL,ECM,ECH,NOWDT,WDT_SW,WDT_NOSL,WDT
// Fuses: PUT,NOPUT,NOMCLR,MCLR,PROTECT,NOPROTECT,CPD,NOCPD,NOBROWNOUT
// Fuses: BROWNOUT_SW,BROWNOUT_NOSL,BROWNOUT,CLKOUT,NOCLKOUT,NOIESO
// Fuses: IESO,NOFCMEN,FCMEN,WRT,WRT_EECON2000,WRT_EECON200,NOWRT
// Fuses: VCAP_A0,VCAP_A5,VCAP_A6,NOVCAP,PLL_SW,PLL,NOSTVREN,STVREN
// Fuses: BORV25,BORV19,DEBUG,NODEBUG,NOLVP,LVP

//Select Jumper RA6,RA7(XTAL/GPIO) = XTAL
//#fuses   HS,PLL,NOWDT,NOPROTECT,NOLVP                                       // X-TAL 8MHz + PLL(x4)
//#use     delay(clock=32000000)                                              // 32.00 MHz

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses   INTRC_IO,PLL,NOWDT,NOPROTECT,NOLVP                                   // Internal RC Clock 8MHz + PLL(4)
#use     delay(clock=32000000)                                                // 32.00 MHz

/* Config and Enable Hardware UART1(RC6=TX1,RC7=RX1 */
#use rs232(uart1, baud=9600, stream=CH1)

/* Config and Enable Software UART2(RC0=TX2,RC1=RX2 */
#define TX2 PIN_C0                                                            // RC0 = TXD
#define RX2 PIN_C1                                                            // RC1 = RXD
#use rs232(baud=9600, xmit=TX2, rcv=RX2,stream=CH2)

/****************/
/* Main Program */
/****************/
void main() 
{  
  char rx_buff;
  
  setup_oscillator(OSC_8MHZ|OSC_PLL_ON);                                      //Sets the Internal Oscillator to 32MHz (PLL Enabled)
  delay_ms(500);                                                              //Power-On Delay
  
  //Start-Up UART1
  fprintf(CH1,"\n\n\n\r");
  fprintf(CH1,"Demo UART1 ET-BASE PIC40/1939(ICD2)\n\r");
  fprintf(CH1,"Run 32.00 MHz(Internal 8 MHz + PLL)\n\r");  
  fprintf(CH1,"UART1>");
  
  //Start-Up UART2
  fprintf(CH2,"\n\n\n\r");
  fprintf(CH2,"Demo UART2 ET-BASE PIC40/1939(ICD2)\n\r");
  fprintf(CH2,"Run 32.00 MHz(Internal 8 MHz + PLL)\n\r");  
  fprintf(CH2,"UART2>");
  
  while(true)
  { 
    //Verify & Echo UART1
    if(kbhit(CH1))
    {
      rx_buff = fgetc(CH1);
      if (rx_buff == 0x0D)
      {
        fprintf(CH1,"\n\r");
        fprintf(CH1,"ET-BASE PIC40/1939(ICD2)\n\r");
        fprintf(CH1,"UART1>");
      }
      else 
      {
        fputc(rx_buff,CH1);                                                   // Echo Received Characters      
      }
    }  
    
    //Verify & Echo UART2
    if(kbhit(CH2))
    {
      rx_buff = fgetc(CH2);
      if (rx_buff == 0x0D)
      {
        fprintf(CH2,"\n\r");
        fprintf(CH2,"ET-BASE PIC40/1939(ICD2)\n\r");
        fprintf(CH2,"UART2>");
      }
      else 
      {
        fputc(rx_buff,CH2);                                                   // Echo Received Characters      
      }
    }  
  }  
}

