/************************************************/
/* Demo Program For ET-BASE PIC40/1939(ICSP)    */
/* MCU Control : PIC16F1939                     */
/*             : Run 32MHz(Internal 8MHz + PLL) */
/* Compiler    : PIC-CCS Version 4.120          */
/* Function    : Demo Switch Control LED ON/OFF */
/************************************************/

#include <16F1939.h>
#include <stdlib.h>

// Fuses: PIC16F1939(CCS Compiler)
// Fuses: LP,XT,HS,RC,INTRC_IO,ECL,ECM,ECH,NOWDT,WDT_SW,WDT_NOSL,WDT
// Fuses: PUT,NOPUT,NOMCLR,MCLR,PROTECT,NOPROTECT,CPD,NOCPD,NOBROWNOUT
// Fuses: BROWNOUT_SW,BROWNOUT_NOSL,BROWNOUT,CLKOUT,NOCLKOUT,NOIESO
// Fuses: IESO,NOFCMEN,FCMEN,WRT,WRT_EECON2000,WRT_EECON200,NOWRT
// Fuses: VCAP_A0,VCAP_A5,VCAP_A6,NOVCAP,PLL_SW,PLL,NOSTVREN,STVREN
// Fuses: BORV25,BORV19,DEBUG,NODEBUG,NOLVP,LVP

//Select Jumper RA6,RA7(XTAL/GPIO) = XTAL
//#fuses   HS,PLL,NOWDT,NOPROTECT,NOLVP                                       // X-TAL 8MHz + PLL(x4)
//#use     delay(clock=32000000)                                              // 32.00 MHz

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses   INTRC_IO,PLL,NOWDT,NOPROTECT,NOLVP                                   // Internal RC Clock 8MHz + PLL(4)
#use     delay(clock=32000000)                                                // 32.00 MHz

//SW1
#define SW1         PIN_A1                                                    // Switch SW1  

//LED Status(Actin High)
#define LED         PIN_A2                                                    // LED Selftest

/****************/
/* Main Program */
/****************/
void main() 
{  
  setup_oscillator(OSC_8MHZ|OSC_PLL_ON);                                      // Sets the Internal Oscillator to 32MHz (PLL Enabled)  
  SETUP_ADC_PORTS(NO_ANALOGS); 
  output_drive(LED);                                                          // LED Drive Pin = Output
  output_float(SW1);                                                          // SW1 Read Pin = Input
  output_low(LED);                                                            // Default LED = OFF  
  
  while(true)
  {   
    while(input(SW1));                                                        // Wait SW1 Press(Low)
    delay_ms(10);
    
    output_toggle(LED);                                                       // Toggle LED
    
    while(!input(SW1));                                                       // Wait SW1 Release(High)
    delay_ms(10);                                                                   
  }  
}


