/************************************************/
/* Demo Program For ET-BASE PIC40/1939(ICSP)    */
/* MCU Control : PIC16F1939                     */
/*             : Run 32MHz(Internal 8MHz + PLL) */
/* Compiler    : PIC-CCS Version 4.120          */
/* Function    : Demo All GPIO Output Demo Test */
/************************************************/
// Used Internal RC 8MHz + PLL(4) Clock
// Select Jumper RA[7..6]/XTAL  = RA[7..6]
// Select Jumper RC[5..3]/USB   = RC[5..3]
// Select Jumper RC[1..0]/UART2 = RC[1..0]

#include <16F1939.h>
#include <stdlib.h>

// Fuses: PIC16F1939(CCS Compiler)
// Fuses: LP,XT,HS,RC,INTRC_IO,ECL,ECM,ECH,NOWDT,WDT_SW,WDT_NOSL,WDT
// Fuses: PUT,NOPUT,NOMCLR,MCLR,PROTECT,NOPROTECT,CPD,NOCPD,NOBROWNOUT
// Fuses: BROWNOUT_SW,BROWNOUT_NOSL,BROWNOUT,CLKOUT,NOCLKOUT,NOIESO
// Fuses: IESO,NOFCMEN,FCMEN,WRT,WRT_EECON2000,WRT_EECON200,NOWRT
// Fuses: VCAP_A0,VCAP_A5,VCAP_A6,NOVCAP,PLL_SW,PLL,NOSTVREN,STVREN
// Fuses: BORV25,BORV19,DEBUG,NODEBUG,NOLVP,LVP

//Select Jumper RA6,RA7(XTAL/GPIO) = XTAL
//#fuses   HS,PLL,NOWDT,NOPROTECT,NOLVP                                       // X-TAL 8MHz + PLL(x4)
//#use     delay(clock=32000000)                                              // 32.00 MHz

//Select Jumper RA6,RA7(XTAL/GPIO) = GPIO
#fuses   INTRC_IO,PLL,NOWDT,NOPROTECT,NOLVP                                   // Internal RC Clock 8MHz + PLL(4)
#use     delay(clock=32000000)                                                // 32.00 MHz

const unsigned char LED[8] =
{
  0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80                              // 8 Bit LED Test
};
 
/****************/
/* Main Program */
/****************/
void main() 
{
  unsigned char count;
  
  setup_oscillator(OSC_8MHZ|OSC_PLL_ON);                                      //Sets the Internal Oscillator to 32MHz (PLL Enabled)
  set_tris_a(0b00000000);                                                     // RA[7..0]=Output
  set_tris_b(0b00000000);                                                     // RB[7..0]=Output
  set_tris_c(0b00000000);                                                     // RC[7..0]=Output
  set_tris_d(0b00000000);                                                     // RD[7..0]=Output
  set_tris_e(0b11111000);                                                     // RE[2..0]=Output
                        
  while(true)
  {    
    for(count = 0; count < 8; count++)                                        // 8 Bit LED 
    {    
      output_a(~LED[count]);    
      output_b(~LED[count]);
      output_c(~LED[count]);
      output_d(~LED[count]);
      output_e(~LED[count]);
      delay_ms(500);                             
    }  
  }
}  

