;*****************************************************
;*          EXAMPLES TO  EXP34PIN (S8252)            *
;*  BOARD  CP-S8252 V2.0                             *
;*  MCS-51 (MCU)                                     *
;*                                                   *
;*  ETT,.CO LTD       TEL 712 1120-1  www.etteam.com *
;*****************************************************
#include <sfr51.inc>
                       ORG    0000H
                       LJMP   RESET_VEC               ;reset vector

RESET_VEC:             MOV     SP,#256-32

INIT_SER:              MOV     TMOD,#00100000B      ;time1 mode2
                       MOV     SCON,#01000000B      ;mode1 serial port
                       MOV     TH1,#0FBH
                       MOV     A,#00H                            
                       MOV     PCON,A               ;SMOD = 0
                       CLR     ET1                  ;clear timer1 interrupt
                       SETB    TR1                  ;start timer1
                       
LOOPX:                 MOV     P0,#0FFH
                       MOV     P1,#0FFH
                       MOV     P2,#0FFH 
                       MOV     R2,#08H
                       MOV     A,#0FFH
                       CLR     C
LOOP:                  RLC     A
                       MOV     P0,A
                       LCALL   DELAY
                       DJNZ    R2,LOOP
                       RLC     A
                       MOV     P0,A
                       MOV     R2,#08H
                       MOV     A,#0FFH
                       CLR     C
LOOP1:                 RLC     A
                       MOV     P1,A
                       LCALL   DELAY
                       DJNZ    R2,LOOP1
                       RLC     A
                       MOV     P1,A
                       MOV     R2,#08H
                       MOV     A,#0FFH
                       CLR     C
LOOP2:                 RLC     A
                       MOV     P2,A
                       LCALL   DELAY
                       DJNZ    R2,LOOP2
                       RLC     A
                       MOV     P2,A
                       SJMP    LOOPX

DELAY:                 PUSH    DPH
                       PUSH    DPL
                       PUSH    ACC
                       MOV     DPTR,#0000H
DEL:                   INC     DPTR
                       MOV     A,DPL
                       ORL     A,DPH
                       JNZ     DEL
                       POP     ACC
                       POP     DPL
                       POP     DPH
                       RET
                       
                       END














