;*****************************************************
;*          EXAMPLES TO WRITE EEPROM 24XX            *
;*  CP-S8252,CP-S53     BOARD                        *
;*  MCS-51 (MCU)                                     *
;*                                                   *
;*  ETT,.CO LTD       TEL 712 1120-1  www.etteam.com *
;*****************************************************

;********************************************************
P0        DATA       080H
SP        DATA       081H
DPL       DATA       082H
DPH       DATA       083H
PCON      DATA       087H
;********************************************************
TCON      DATA       088H
TMOD      DATA       089H
TL0       DATA       08AH
TL1       DATA       08BH
TH0       DATA       08CH
TH1       DATA       08DH
;********************************************************
P1        DATA       090H
;********************************************************
SCON      DATA       098H
SBUF      DATA       099H
;********************************************************
P2        DATA       0A0H
;********************************************************
IE        DATA       0A8H
;********************************************************
P3        DATA       0B0H
;********************************************************
IP        DATA       0B8H
;********************************************************
T2CON     DATA       0C8H
TL2       DATA       0CBH
TH2       DATA       0CDH
;********************************************************
T2MOD     DATA       0C9H
;********************************************************
RCAP2L    DATA       0CAH
RCAP2H    DATA       0CBH

;********************************************************
ACC       DATA       0E0H

;********************************************************
B         DATA       0F0H 
 

;********************************************************
;*               bit address
;********************************************************
IT0       BIT       088H
IE0       BIT       089H
IT1       BIT       08AH
IE1       BIT       08BH
TRO       BIT       08CH
TF0       BIT       08DH
TR1       BIT       08EH
TF1       BIT       08FH

;********************************************************
RI        BIT       098H     
TI        BIT       099H
RB8       BIT       09AH
TB8       BIT       09BH
REN       BIT       09CH
SM2       BIT       09DH
SM1       BIT       09EH
SM0       BIT       09FH

;********************************************************
EX0       BIT       0A8H
ET0       BIT       0A9H
EX1       BIT       0AAH
ET1       BIT       0ABH
ES        BIT       0ACH
ET2       BIT       0ADH
EA        BIT       0AFH

;********************************************************
PX0       BIT       0B8H
PT0       BIT       0B9H 
PX1       BIT       0BAH 
PT1       BIT       0BBH
PS        BIT       0BCH
PT2       BIT       0BDH
PCT       BIT       0BFH

;********************************************************
P         BIT       0D0H
F1        BIT       0D1H
OV        BIT       0D2H
RS0       BIT       0D3H
RS1       BIT       0D4H
F0        BIT       0D5H
AC        BIT       0D6H
CY        BIT       0D7H

;********************************************************

											 ORG    0000H
                       LJMP   RESET_VEC               ;reset vector

RESET_VEC:             MOV     SP,#256-32

INIT_SER:              MOV     TMOD,#00100000B      ;time1 mode2
                       MOV     SCON,#01000000B      ;mode1 serial port
                       MOV     TH1,#0FBH
                       MOV     A,#00H                            
                       MOV     PCON,A               ;SMOD = 0
                       CLR     ET1                  ;clear timer1 interrupt
                       SETB    TR1                  ;start timer1
                       
LOOPX:                 MOV     P0,#0FFH
                       MOV     P1,#0FFH
                       MOV     P2,#0FFH 
                       MOV     R2,#08H
                       MOV     A,#0FFH
                       CLR     C
LOOP:                  RLC     A
                       MOV     P0,A
                       LCALL   DELAY
                       DJNZ    R2,LOOP
                       RLC     A
                       MOV     P0,A
                       MOV     R2,#08H
                       MOV     A,#0FFH
                       CLR     C
LOOP1:                 RLC     A
                       MOV     P1,A
                       LCALL   DELAY
                       DJNZ    R2,LOOP1
                       RLC     A
                       MOV     P1,A
                       MOV     R2,#08H
                       MOV     A,#0FFH
                       CLR     C
LOOP2:                 RLC     A
                       MOV     P2,A
                       LCALL   DELAY
                       DJNZ    R2,LOOP2
                       RLC     A
                       MOV     P2,A
                       SJMP    LOOPX

DELAY:                 PUSH    DPH
                       PUSH    DPL
                       PUSH    ACC
                       MOV     DPTR,#0000H
DEL:                   INC     DPTR
                       MOV     A,DPL
                       ORL     A,DPH
                       JNZ     DEL
                       POP     ACC
                       POP     DPL
                       POP     DPH
                       RET
                       
                       END














