;******************************************************
;*             Program Test Serial Port               *
;*             Hardware : CP-S8252  V2.0              *
;*             Complier : SXA51                       *
;******************************************************
;********************************************************
P0        DATA       080H
SP        DATA       081H
DPL       DATA       082H
DPH       DATA       083H
PCON      DATA       087H
;********************************************************
TCON      DATA       088H
TMOD      DATA       089H
TL0       DATA       08AH
TL1       DATA       08BH
TH0       DATA       08CH
TH1       DATA       08DH
;********************************************************
P1        DATA       090H
;********************************************************
SCON      DATA       098H
SBUF      DATA       099H
;********************************************************
P2        DATA       0A0H
;********************************************************
IE        DATA       0A8H
;********************************************************
P3        DATA       0B0H
;********************************************************
IP        DATA       0B8H
;********************************************************
T2CON     DATA       0C8H
TL2       DATA       0CBH
TH2       DATA       0CDH
;********************************************************
T2MOD     DATA       0C9H
;********************************************************
RCAP2L    DATA       0CAH
RCAP2H    DATA       0CBH

;********************************************************
ACC       DATA       0E0H

;********************************************************
B         DATA       0F0H 
 

;********************************************************
;*               bit address
;********************************************************
IT0       BIT       088H
IE0       BIT       089H
IT1       BIT       08AH
IE1       BIT       08BH
TRO       BIT       08CH
TF0       BIT       08DH
TR1       BIT       08EH
TF1       BIT       08FH

;********************************************************
RI        BIT       098H     
TI        BIT       099H
RB8       BIT       09AH
TB8       BIT       09BH
REN       BIT       09CH
SM2       BIT       09DH
SM1       BIT       09EH
SM0       BIT       09FH

;********************************************************
EX0       BIT       0A8H
ET0       BIT       0A9H
EX1       BIT       0AAH
ET1       BIT       0ABH
ES        BIT       0ACH
ET2       BIT       0ADH
EA        BIT       0AFH

;********************************************************
PX0       BIT       0B8H
PT0       BIT       0B9H 
PX1       BIT       0BAH 
PT1       BIT       0BBH
PS        BIT       0BCH
PT2       BIT       0BDH
PCT       BIT       0BFH

;********************************************************
P         BIT       0D0H
F1        BIT       0D1H
OV        BIT       0D2H
RS0       BIT       0D3H
RS1       BIT       0D4H
F0        BIT       0D5H
AC        BIT       0D6H
CY        BIT       0D7H

;********************************************************

            ORG     0000H
            LJMP    MAIN                              ;reset vecter
            ;
MAIN:       MOV     SP,#256-32                        ;define stack = 32 byte
            ;
INIT_SER:   MOV     TMOD,#00100000B                   ;time1 mode2
            MOV     SCON,#01010000B                   ;mode1 serial port
            MOV     TH1,#0FBH
            MOV     A,#00H
            MOV     PCON,A                            ;SMOD = 0
            CLR     ET1                               ;clear timer1 interrupt
            SETB    TR1                               ;start timer1
            CLR     ES
            CLR     EA
            ;
SER:        MOV     DPTR,#TEXT_TAB
            MOV     A,#0
SER1:       PUSH    ACC
            MOVC    A,@A+DPTR
            CJNE    A,#00H,TX1
            POP     ACC
            SJMP    TX2
TX1:        LCALL   TX_BYTE
            POP     ACC
            INC     A
            SJMP    SER1

TX2:        LCALL   RX_BYTE
            MOV     DPTR,#TX_TAB
            MOV     A,#00H
TX4:        PUSH    ACC
            MOVC    A,@A+DPTR
            CJNE    A,#00H,TX3
            LJMP    TX2
            POP     ACC
TX3:        LCALL   TX_BYTE
            POP     ACC
            INC     A
            SJMP    TX4  
            
;******************************************************
;*                Send 1-Byte to SERIAL               *
;*                Input   : ACC                       *
;*                Output  : Serial port               *
;******************************************************
TX_BYTE:    PUSH   IE
            CLR    TI
            MOV    SBUF,A
            JNB    TI,$
            CLR    TI
            POP    IE
            RET

;******************************************************
;*              Receive Data From SERIAL              *
;*              Input   :  Serial Port                *
;*              Output  :  ACC                        *
;******************************************************
RX_BYTE:    PUSH   IE
            JNB    RI,$             ; Wait data
            CLR    RI
            MOV    A,SBUF
            POP    IE
            RET


TEXT_TAB:   DB    0CH,'TEST SERIAL PORT (RS232)',0AH,0DH
            DB    'CP-S8252 (AT89S8252)',0AH,0DH
            DB    'PRESS ANY KEY',0AH,0DH,0AH,0DH,00H

TX_TAB:     DB    'CP-S8252 TX WORD!',0AH,0DH
            DB    '"SYSTEMS COMPLETE"',0AH,0DH
            DB    'THANK YOU VERY MUCH',0AH,0DH,0AH,0DH,00H

            END









