;****************************************************
;*          Program Test 4 Bits LCD                 *
;*          Dot Matrix TM1620 16X2                  *
;*          HardWare : CP-S8252 V2.0                *
;*          Complier : SXA51                        *
;****************************************************
;********************************************************
P0        DATA       080H
SP        DATA       081H
DPL       DATA       082H
DPH       DATA       083H
PCON      DATA       087H
;********************************************************
TCON      DATA       088H
TMOD      DATA       089H
TL0       DATA       08AH
TL1       DATA       08BH
TH0       DATA       08CH
TH1       DATA       08DH
;********************************************************
P1        DATA       090H
;********************************************************
SCON      DATA       098H
SBUF      DATA       099H
;********************************************************
P2        DATA       0A0H
;********************************************************
IE        DATA       0A8H
;********************************************************
P3        DATA       0B0H
;********************************************************
IP        DATA       0B8H
;********************************************************
T2CON     DATA       0C8H
TL2       DATA       0CBH
TH2       DATA       0CDH
;********************************************************
T2MOD     DATA       0C9H
;********************************************************
RCAP2L    DATA       0CAH
RCAP2H    DATA       0CBH

;********************************************************
ACC       DATA       0E0H

;********************************************************
B         DATA       0F0H 
 

;********************************************************
;*               bit address
;********************************************************
IT0       BIT       088H
IE0       BIT       089H
IT1       BIT       08AH
IE1       BIT       08BH
TRO       BIT       08CH
TF0       BIT       08DH
TR1       BIT       08EH
TF1       BIT       08FH

;********************************************************
RI        BIT       098H     
TI        BIT       099H
RB8       BIT       09AH
TB8       BIT       09BH
REN       BIT       09CH
SM2       BIT       09DH
SM1       BIT       09EH
SM0       BIT       09FH

;********************************************************
EX0       BIT       0A8H
ET0       BIT       0A9H
EX1       BIT       0AAH
ET1       BIT       0ABH
ES        BIT       0ACH
ET2       BIT       0ADH
EA        BIT       0AFH

;********************************************************
PX0       BIT       0B8H
PT0       BIT       0B9H 
PX1       BIT       0BAH 
PT1       BIT       0BBH
PS        BIT       0BCH
PT2       BIT       0BDH
PCT       BIT       0BFH

;********************************************************
P         BIT       0D0H
F1        BIT       0D1H
OV        BIT       0D2H
RS0       BIT       0D3H
RS1       BIT       0D4H
F0        BIT       0D5H
AC        BIT       0D6H
CY        BIT       0D7H

;********************************************************

						ORG     0000H
            LJMP    MAIN

CS_LCD      EQU     P1.3          ; E  LCD (PIN INT1)
RS_LCD      EQU     P1.2          ; RS LCD (Pin T0)
            ;
MAIN:       MOV     SP,#256-32    ; Initial Stack 32 Byte
            CLR     EA

            SETB    CS_LCD        ; initial LCD

            LCALL   DELAY         ; initial delay

            LCALL   INIT_LCD      ; initial LCD

;****************************************************
;*                    show LCD                      *
;****************************************************
            MOV     A,#0
            MOV     DPTR,#LCD_TAB
WRITE1:     PUSH    ACC
            MOVC    A,@A+DPTR
            CJNE    A,#00H,WRITE
            POP     ACC
            LJMP    $
WRITE:      LCALL   WR_LCD
            POP     ACC
            INC     ACC
            LJMP    WRITE1
            LJMP    $
           
;****************************************************
;*                Input  : ACC  (ASCII)             *
;*                Output : Data bus LCD             *
;****************************************************
WR_LCD:     MOV     B,A
            ANL     A,#0F0H
            ORL     A,#00001100B    ;RS/CS HI
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B
            ORL     A,R2
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B             ;Low byte
            SWAP    A
            ANL     A,#0F0H
            ORL     A,#00001100B
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B
            ORL     A,R2
            MOV     P1,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WR_INS:     MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.3           ;CS HI
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B    ;else bit
            ORL     A,R2
            MOV     P1,A            ; High byte
            LCALL   EN_LCD
            MOV     A,B             ; Low byte
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.3
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B
            ORL     A,R2
            MOV     P1,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                 Goto position of LCD             *
;*                 Input : ACC (addr.)              *
;****************************************************
GOTO_LCD:   SETB    ACC.7
            LCALL   WR_INS
            RET

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H          ; Set DL = 1 3-time
            LCALL   WR_INS
            MOV     A,#32H          ; Clear DL = 0 1-time
            LCALL   WR_INS
            MOV     A,#28H          ; Function set
            LCALL   WR_INS          ; DL=0 4Bit,N=1 2Line,F=0 5X7
            MOV     A,#0CH
            LCALL   WR_INS          ; Entry display,cursor off,cursor not blink
            MOV     A,#06H          ; Entry mode set
            LCALL   WR_INS          ; I/D=1 Increment,S=0 cursor shift
            MOV     A,#01H          ; Clear display
            LCALL   WR_INS          ; Clear display,set DD RAM address=0
            RET
;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     CLR     CS_LCD          ; Enable LCD
            LCALL   BUSY            ; Busy delay time
            SETB    CS_LCD          ; Disable LCD
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#05H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    07H
            PUSH    06H
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            POP     06H
            POP     07H
            RET

LCD_TAB:    DB   'CP-S8252/CP-S53',00H

            END

