;*****************************************
;* examples program for ET-LAB3A         *
;* description : read DS1820             *
;* compiler    : cross32                 *
;*****************************************
P0:         EQU     080H
SP:         EQU     081H
DPL:        EQU     082H
DPH:        EQU     083H
PCON:       EQU     087H
TCON:       EQU     088H
TMOD:       EQU     089H
TL0:        EQU     08AH
TL1:        EQU     08BH
TH0:        EQU     08CH
TH1:        EQU     08DH
P1:         EQU     090H
SCON:       EQU     098H
SBUF:       EQU     099H
P2:         EQU     0A0H
IE:         EQU     0A8H
P3:         EQU     0B0H
IP:         EQU     0B8H
T2CON:      EQU     0C8H
RCAP2L:     EQU     0CAH
RCAP2H:     EQU     0CBH
TL2:        EQU     0CCH
TH2:        EQU     0CDH
PSW:        EQU     0D0H
ACC:        EQU     0E0H
B:          EQU     0F0H
;
P0.0:       EQU     080H
P0.1:       EQU     081H
P0.2:       EQU     082H
P0.3:       EQU     083H
P0.4:       EQU     084H
P0.5:       EQU     085H
P0.6:       EQU     086H
P0.7:       EQU     087H
IT0:        EQU     088H
IE0:        EQU     089H
IT1:        EQU     08AH
IE1:        EQU     08BH
TR0:        EQU     08CH
TF0:        EQU     08DH
TR1:        EQU     08EH
TF1:        EQU     08FH
P1.0:       EQU     090H
P1.1:       EQU     091H
P1.2:       EQU     092H
P1.3:       EQU     093H
P1.4:       EQU     094H
P1.5:       EQU     095H
P1.6:       EQU     096H
P1.7:       EQU     097H
RI:         EQU     098H
TI:         EQU     099H
RB8:        EQU     09AH
TB8:        EQU     09BH
REN:        EQU     09CH
SM2:        EQU     09DH
SM1:        EQU     09EH
SM0:        EQU     09FH
P2.0:       EQU     0A0H
P2.1:       EQU     0A1H
P2.2:       EQU     0A2H
P2.3:       EQU     0A3H
P2.4:       EQU     0A4H
P2.5:       EQU     0A5H
P2.6:       EQU     0A6H
P2.7:       EQU     0A7H
EX0:        EQU     0A8H
ET0:        EQU     0A9H
EX1:        EQU     0AAH
ET1:        EQU     0ABH
ES:         EQU     0ACH
ET2:        EQU     0ADH
EA:         EQU     0AFH
P3.0:       EQU     0B0H
P3.1:       EQU     0B1H
P3.2:       EQU     0B2H
P3.3:       EQU     0B3H
P3.4:       EQU     0B4H
P3.5:       EQU     0B5H
P3.6:       EQU     0B6H
P3.7:       EQU     0B7H
PX0:        EQU     0B8H
PT0:        EQU     0B9H
PX1:        EQU     0BAH
PT1:        EQU     0BBH
PS:         EQU     0BCH
PT2:        EQU     0BDH
T2CP:       EQU     0C8H
T2C:        EQU     0C9H
TR2:        EQU     0CAH
EXEN2:      EQU     0CBH
TLCK:       EQU     0CCH
RCLK:       EQU     0CDH
EXF2:       EQU     0CEH
TF2:        EQU     0CFH
P:          EQU     0D0H
OV:         EQU     0D2H
RS0:        EQU     0D3H
RS1:        EQU     0D4H
F0:         EQU     0D5H
AC:         EQU     0D6H
CY:         EQU     0D7H
ACC.0:      EQU     0E0H
ACC.1:      EQU     0E1H
ACC.2:      EQU     0E2H
ACC.3:      EQU     0E3H
ACC.4:      EQU     0E4H
ACC.5:      EQU     0E5H
ACC.6:      EQU     0E6H
ACC.7:      EQU     0E7H
B.0:        EQU     0F0H
B.1:        EQU     0F1H
B.2:        EQU     0F2H
B.3:        EQU     0F3H
B.4:        EQU     0F4H
B.5:        EQU     0F5H
B.6:        EQU     0F6H
B.7:        EQU     0F7H

            CPU     "8051.TBL"
            HOF     "INT8"


             ORG     0000H         ;reset vector
             LJMP    MAIN

DATA_BIT     EQU     P0.1

PORT_LCD     EQU     P1
E_LCD        EQU     P1.2        ;Enable LCD
WR_LCD       EQU     P1.1        ;WR LCD
RS_LCD       EQU     P1.0        ;RS Select LCD 

             ORG     25H
BUFFER:      DFS      10

MAIN:        MOV     SP,#256-32    ; Initial Stack 32 Byte
             CLR     EA

             LCALL   DELAY         ; initial delay

             LCALL   INIT_LCD      ; initial LCD

             MOV     DPTR,#TEMP_TEXT
SSP1:        MOV     A,#0
             MOVC    A,@A+DPTR
             CJNE    A,#0DH,SSP
             LJMP    LOOP
SSP:         INC     DPTR
             LCALL   WRITE_DATA
             LJMP    SSP1


LOOP:        LCALL   READROM

             LCALL   SKIPROM

             LCALL   CONVERTTEMP
             LCALL   DELAY

             LCALL   SKIPROM
             LCALL   READSCRATCHPAD

             MOV     A,#08H
             LCALL   GOTOLCD

             MOV     R0,#BUFFER+0       ;READ POSITIVE TEMPERATUR ONLY
             MOV     A,@R0
             CLR     C
             RRC     A

             MOV     DPTR,#HEXDEC       ;HEX TO DEC
             MOVC    A,@A+DPTR

             PUSH    ACC
             SWAP    A
             ANL     A,#0FH
             LCALL   HEXASC
             LCALL   WRITE_DATA

             POP     ACC
             ANL     A,#0FH
             LCALL   HEXASC
             LCALL   WRITE_DATA

             LJMP    LOOP         



READROM:     LCALL   TOUCHRESET
             JNC     READROM

             MOV     A,#33H
             LCALL   TOUCHBYTE

             MOV     R7,#8
             MOV     R0,#BUFFER
ROMLOOP:     MOV     A,#0FFH
             LCALL   TOUCHBYTE
             MOV     @R0,A
             INC     R0
             DJNZ    R7,ROMLOOP
             RET


SKIPROM:     LCALL   TOUCHRESET
             JNC     SKIPROM

             MOV     A,#0CCH
             LCALL   TOUCHBYTE
             RET

CONVERTTEMP: MOV     A,#44H
             LCALL   TOUCHBYTE
             RET

READSCRATCHPAD: MOV    A,#0BEH
                LCALL  TOUCHBYTE

                MOV    R7,#9
                MOV    R0,#BUFFER
SCATCHLOOP:     MOV    A,#0FFH
                LCALL  TOUCHBYTE
                MOV    @R0,A
                INC    R0
                DJNZ   R7,SCATCHLOOP
                LCALL  TOUCHRESET
                RET


TOUCHRESET:
             PUSH   ACC                 ;     SAVE THE ACCUMULATOR
             MOV    A,#12               ;     LOAD OUTER LOOP VARIABLE
             CLR    DATA_BIT            ;     START THE RESET PULSE 
             MOV    R1,#3               ;
DELRESET:    MOV    R2,#245             ;2.   SET TIME INTERVAL
             DJNZ   R2,$                ;490. WAIT WITH DATA LOW
             DJNZ   R1,DELRESET         ;
             SETB   DATA_BIT            ;1.   RELEASE DATA LINE
             MOV    B,#20               ;2.   SET TIME INTERVAL
             CLR    C                   ;1.   CLEAR PRESENCE FLAG
WAITLOW:
             JB     DATA_BIT,WH         ;EXIT LOOP IF LINE HIGH
             DJNZ   B,WAITLOW           ;HANG AROUND FOR 3360
             DJNZ   ACC,WAITLOW         ;US IF LINE IS LOW
             SJMP   SHORT               ;LINE COULD NOT GO HIGH
WH:
             MOV    R1,#255             ;DELAY FOR PRESENCE DETECT
HL:
             ORL    C,/DATA_BIT         ;2.   CATCH PRESENCE PULSE
             DJNZ   R1,HL               ;510  WAIT WITH DATA HIGH
SHORT:
             POP    ACC                 ;RESTORE ACCUMULATOR
             RET                        ;RETURN



TOUCHBYTE:
             PUSH   B                   ;SAVE THE B REGISTER
             MOV    B,#8                ;SETUP FOR 8 BIT
BIT_LOOP:
             RRC    A                   ;GET BIT IN CARRY
             LCALL  TOUCHBIT            ;SEND BIT
             DJNZ   B,BIT_LOOP          ;GET NEXT BIT
             RRC    A                   ;GET FINAL BIT IN ACC
             POP    B                   ;RESTORE B REGISTER
             RET                        ;RETURN TO CALLER


TOUCHBIT:    CLR   DATA_BIT             ;1.     START THE TIME SLOT
             MOV   R1,#4                ;1.
             DJNZ  R1,$                 ;2 X 4  DELAY ~ 3 US

             MOV   DATA_BIT,C           ;1      SEND OUT THE DATA BIT
             MOV   R1,#10               ;1
             DJNZ  R1,$                 ;2 X 10 DELAY ~ 7 US

             MOV   C,DATA_BIT           ;1      SAMPLE INPUT DATA BIT
             MOV   R1,#90               ;1
             DJNZ  R1,$                 ;2 X 90 DELAY ~ 59 US
             SETB  DATA_BIT             ;TERMINATE TIME SLOT
             RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WRITE_INS:  MOV     B,A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            RET

WRITE_DATA: MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            RET 

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H       
            LCALL   WRITE_INS
            MOV     A,#32H       
            LCALL   WRITE_INS
            MOV     A,#28H        
            LCALL   WRITE_INS         
            MOV     A,#01H
            LCALL   WRITE_INS         
            MOV     A,#02H          
            LCALL   WRITE_INS          
            MOV     A,#0EH         
            LCALL   WRITE_INS          
            RET


GOTOLCD:    SETB   ACC.7
            LCALL  WRITE_INS
            RET

;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     SETB    E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            CLR     E_LCD           ;Disable LCD
            LCALL   BUSY
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#05H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET


;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    07H
            PUSH    06H
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            POP     06H
            POP     07H
            RET

;****************************************************
;*              convert hex to ascii                *
;****************************************************
HEXASC:     CJNE    A,#0AH,HEX
HEX:        JNC     MORE
            ADD     A,#30H
            RET
MORE:       ADD     A,#37H
            RET

HEXDEC:     DFB        00H,01H,02H,03H,04H,05H,06H,07H,08H,09H
            DFB        10H,11H,12H,13H,14H,15H,16H,17H,18H,19H
            DFB        20H,21H,22H,23H,24H,25H,26H,27H,28H,29H
            DFB        30H,31H,32H,33H,34H,35H,36H,37H,38H,39H
            DFB        40H,41H,42H,43H,44H,45H,46H,47H,48H,49H
            DFB        50H,51H,52H,53H,54H,55H,56H,57H,58H,59H
            DFB        60H,61H,62H,63H,64H,65H,66H,67H,68H,69H
            DFB        70H,71H,72H,73H,74H,75H,76H,77H,78H,79H
            DFB        80H,81H,82H,83H,84H,85H,86H,87H,88H,89H
            DFB        90H,91H,92H,93H,94H,95H,96H,97H,85H,99H

TEMP_TEXT:  DFB   "TEMP =      C",0DH 

            END


