;******************************************
;* examples program for ET-LAB3A          *
;* description : read & write DS1307      *
;* compiler    : cross32                  *
;******************************************
P0:         EQU     080H
SP:         EQU     081H
DPL:        EQU     082H
DPH:        EQU     083H
PCON:       EQU     087H
TCON:       EQU     088H
TMOD:       EQU     089H
TL0:        EQU     08AH
TL1:        EQU     08BH
TH0:        EQU     08CH
TH1:        EQU     08DH
P1:         EQU     090H
SCON:       EQU     098H
SBUF:       EQU     099H
P2:         EQU     0A0H
IE:         EQU     0A8H
P3:         EQU     0B0H
IP:         EQU     0B8H
T2CON:      EQU     0C8H
RCAP2L:     EQU     0CAH
RCAP2H:     EQU     0CBH
TL2:        EQU     0CCH
TH2:        EQU     0CDH
PSW:        EQU     0D0H
ACC:        EQU     0E0H
B:          EQU     0F0H
;
P0.0:       EQU     080H
P0.1:       EQU     081H
P0.2:       EQU     082H
P0.3:       EQU     083H
P0.4:       EQU     084H
P0.5:       EQU     085H
P0.6:       EQU     086H
P0.7:       EQU     087H
IT0:        EQU     088H
IE0:        EQU     089H
IT1:        EQU     08AH
IE1:        EQU     08BH
TR0:        EQU     08CH
TF0:        EQU     08DH
TR1:        EQU     08EH
TF1:        EQU     08FH
P1.0:       EQU     090H
P1.1:       EQU     091H
P1.2:       EQU     092H
P1.3:       EQU     093H
P1.4:       EQU     094H
P1.5:       EQU     095H
P1.6:       EQU     096H
P1.7:       EQU     097H
RI:         EQU     098H
TI:         EQU     099H
RB8:        EQU     09AH
TB8:        EQU     09BH
REN:        EQU     09CH
SM2:        EQU     09DH
SM1:        EQU     09EH
SM0:        EQU     09FH
P2.0:       EQU     0A0H
P2.1:       EQU     0A1H
P2.2:       EQU     0A2H
P2.3:       EQU     0A3H
P2.4:       EQU     0A4H
P2.5:       EQU     0A5H
P2.6:       EQU     0A6H
P2.7:       EQU     0A7H
EX0:        EQU     0A8H
ET0:        EQU     0A9H
EX1:        EQU     0AAH
ET1:        EQU     0ABH
ES:         EQU     0ACH
ET2:        EQU     0ADH
EA:         EQU     0AFH
P3.0:       EQU     0B0H
P3.1:       EQU     0B1H
P3.2:       EQU     0B2H
P3.3:       EQU     0B3H
P3.4:       EQU     0B4H
P3.5:       EQU     0B5H
P3.6:       EQU     0B6H
P3.7:       EQU     0B7H
PX0:        EQU     0B8H
PT0:        EQU     0B9H
PX1:        EQU     0BAH
PT1:        EQU     0BBH
PS:         EQU     0BCH
PT2:        EQU     0BDH
T2CP:       EQU     0C8H
T2C:        EQU     0C9H
TR2:        EQU     0CAH
EXEN2:      EQU     0CBH
TLCK:       EQU     0CCH
RCLK:       EQU     0CDH
EXF2:       EQU     0CEH
TF2:        EQU     0CFH
P:          EQU     0D0H
OV:         EQU     0D2H
RS0:        EQU     0D3H
RS1:        EQU     0D4H
F0:         EQU     0D5H
AC:         EQU     0D6H
CY:         EQU     0D7H
ACC.0:      EQU     0E0H
ACC.1:      EQU     0E1H
ACC.2:      EQU     0E2H
ACC.3:      EQU     0E3H
ACC.4:      EQU     0E4H
ACC.5:      EQU     0E5H
ACC.6:      EQU     0E6H
ACC.7:      EQU     0E7H
B.0:        EQU     0F0H
B.1:        EQU     0F1H
B.2:        EQU     0F2H
B.3:        EQU     0F3H
B.4:        EQU     0F4H
B.5:        EQU     0F5H
B.6:        EQU     0F6H
B.7:        EQU     0F7H

            CPU     "8051.TBL"
            HOF     "INT8"

            ORG     0000H
            LJMP    RESET_VEC               ;reset vector

SCL         EQU     P0.0
SDA         EQU     P0.1

CONT_BW     EQU     0D0H
CONT_BR     EQU     0D1H

            ORG     25H
ADDRESS:    DFS      1
DATA:       DFS      1

PORT_LCD    EQU     P1              ;Port  LCD
E_LCD       EQU     P1.2      ;Enable LCD
WR_LCD      EQU     P1.1      ;WR LCD
RS_LCD      EQU     P1.0      ;RS Select LCD 



RESET_VEC:  MOV     SP,#256-32
            CLR     EA

INIT_PORT:  SETB    SCL
            SETB    SDA

            CLR     WR_LCD          ;write LCD
            SETB    E_LCD           ;initial LCD

            LCALL   DELAY           ;initial delay

            LCALL   INIT_LCD        ;initial LCD

            MOV     DPTR,#TEXT
SSP2:       MOV     A,#0
            MOVC    A,@A+DPTR
            CJNE    A,#0DH,SSP
            LJMP    SSP1
SSP:        LCALL   WR_DATA
            INC     DPTR
            LJMP    SSP2

SSP1:       MOV     ADDRESS,#0
            MOV     DATA,#0
            LCALL   WRITE_BYTE

LOOP:       MOV     ADDRESS,#02H
            LCALL   READ_BYTE

            MOV     A,#40H
            LCALL   GOTO_LCD

            MOV     A,DATA
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     A,DATA
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     ADDRESS,#01H
            LCALL   READ_BYTE

            MOV     A,#43H
            LCALL   GOTO_LCD

            MOV     A,DATA
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     A,DATA
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA


            MOV     ADDRESS,#00H
            LCALL   READ_BYTE

            MOV     A,#46H
            LCALL   GOTO_LCD

            MOV     A,DATA
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     A,DATA
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA


            SJMP    LOOP


;*****************************************************
;*            WRITE DATA TO EEPROM 1 BYTE            *
;*      : DATA                                       *
;*****************************************************
WRITE_BYTE: CLR     SDA                    ;start bit
            CLR     SCL

            MOV     A,#CONT_BW             ;send control byte
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,WRITE_BYTE         ;loop until busy
            CLR     SCL
            NOP
            NOP

            MOV     A,ADDRESS              ;send address low
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,WRITE_BYTE         ;loop until busy
            CLR     SCL
            NOP
            NOP

            MOV     A,DATA                 ;send data
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,WRITE_BYTE         ;loop until busy
            CLR     SCL
            NOP
            NOP
            CLR     SDA

            SETB    SCL                    ;stop bit
            SETB    SDA
            LCALL   DELAY
            RET

;******************************************************
;*            READ DATA FROM EEPROM 1 BYTE            *
;* OUTPUT : DATA                                      *
;******************************************************
READ_BYTE:  CLR     SDA                    ;start bit
            CLR     SCL

            MOV     A,#CONT_BW             ;send control byte
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,READ_BYTE          ;loop until busy
            CLR     SCL
            NOP
            NOP

            MOV     A,ADDRESS              ;send address low
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,READ_BYTE         ;loop until busy
            CLR     SCL
            NOP
            NOP

            SETB    SCL

            CLR     SDA                    ;start bit
            CLR     SCL

            MOV     A,#CONT_BR             ;send control byte
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,READ_BYTE          ;loop until busy
            CLR     SCL
            NOP
            NOP

            LCALL   GET_BYTE
            MOV     DATA,A

            SETB    SDA
            SETB    SCL                    ;NO ACK
            CLR     SCL

            CLR     SDA

            SETB    SCL                   ;stop bit
            SETB    SDA
            LCALL   DELAY
            RET


;****************************************************
;*                      WRITE                       *
;* INPUT: ACC                                       *
;****************************************************
PUT_BYTE:   PUSH    02H
            MOV     R2,#08H
PUT1:       RLC     A
            MOV     SDA,C
            SETB    SCL
            NOP
            NOP
            CLR     SCL
            NOP
            NOP
            DJNZ    R2,PUT1
            POP     02H
            RET

;*****************************************************
;*                       READ                        *
;* OUTPUT: ACC                                       *
;*****************************************************
GET_BYTE:   PUSH    02H
            MOV     R2,#08H
GET1:       SETB    SCL
            NOP
            NOP
            MOV     C,SDA
            CLR     SCL
            NOP
            NOP
            RLC     A
            DJNZ    R2,GET1
            POP     02H
            RET

;***************************************************
;*                     delay
;***************************************************
DELAY4M:    PUSH    DPH
            PUSH    DPL
            MOV     DPTR,#0000H
DEL4:       INC     DPTR
            MOV     A,DPL
            ORL     A,DPH
            JNZ     DEL4
            POP     DPL
            POP     DPH
            RET

;****************************************************
;*                Input  : ACC  (ASCII)             *
;*                Output : Data bus LCD             *
;****************************************************
WR_DATA:    MOV     B,A
            ANL     A,#0F0H
            ORL     A,#00000101B    ;RS/CS HI
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B
            ORL     A,R2
            MOV     PORT_LCD,A
            LCALL   EN_LCD
            MOV     A,B             ;Low byte
            SWAP    A
            ANL     A,#0F0H
            ORL     A,#00000101B
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B
            ORL     A,R2
            MOV     PORT_LCD,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WR_INS:     MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.2           ;E HI
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B    ;else bit
            ORL     A,R2
            MOV     PORT_LCD,A      ;High byte
            LCALL   EN_LCD
            MOV     A,B             ;Low byte
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.2
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B
            ORL     A,R2
            MOV     PORT_LCD,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                 Goto position of LCD             *
;*                 Input : ACC (addr.)              *
;****************************************************
GOTO_LCD:   SETB    ACC.7
            LCALL   WR_INS
            RET

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H          ;Set DL = 1 3-time
            LCALL   WR_INS
            MOV     A,#32H          ;Clear DL = 0 1-time
            LCALL   WR_INS
            MOV     A,#28H          ;Function set
            LCALL   WR_INS          ;DL=0 4Bit,N=1 2Line,F=0 5X7
            MOV     A,#0CH
            LCALL   WR_INS          ;Entry display,cursor off,cursor not blink
            MOV     A,#06H          ;Entry mode set
            LCALL   WR_INS          ;I/D=1 Increment,S=0 cursor shift
            MOV     A,#01H          ;Clear display
            LCALL   WR_INS          ;Clear display,set DD RAM address=0
            RET
;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     CLR     E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            SETB    E_LCD           ;Disable LCD
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#0AH
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    DPH
            PUSH    DPL
            PUSH    ACC
            MOV     DPTR,#0000H
DEL:        INC     DPTR
            MOV     A,DPL
            ORL     A,DPH
            JNZ     DEL
            POP     ACC
            POP     DPL
            POP     DPH
            RET

;**********************************************
;*         convert hex to ascii               * 
;**********************************************
HEXASC:     CJNE    A,#10,CHECK
CHECK:      JNC     MORE
            ADD     A,#30H
            RET
MORE:       ADD     A,#37H 
            RET

TEXT:       DFB     "HH:MM:SS",0DH

            END














