;*******************************************
;* EXAMPLE PROGRAM FOR ET-LAB3A            *
;* DESCRIPTION : SCAN DOT MATRIX LED       *
;* COMPILER    : SXA51                     *
;*******************************************

PORT_DSP       EQU    P1

COL_RESET      EQU    PORT_DSP.0
COL_SHIFT      EQU    PORT_DSP.1
COL_LATCH      EQU    PORT_DSP.2
COL_ENABLE     EQU    PORT_DSP.3
COL_DATA       EQU    PORT_DSP.5

ROW_ENABLE     EQU    PORT_DSP.4
ROW_RESET      EQU    PORT_DSP.6
ROW_DATA       EQU    PORT_DSP.7


               ORG    0000H
MAIN:          MOV    SP,#256-32            ;stack = 32 byte 


LOOP:          LCALL  SCAN_DSP              ;scan display away
               SJMP   LOOP


SCAN_DSP:      SETB  COL_RESET
               CLR   ROW_ENABLE
               SETB  ROW_RESET
               CLR   ROW_RESET

               MOV   B,#7
SCAN_DSP1:     SETB  COL_ENABLE

               MOV   A,#0FFH                ;send FFH byte 1 
               CPL   A
               LCALL SER_OUT

               MOV   A,#0FFH                ;send FFH byte 2
               CPL   A
               LCALL SER_OUT

               SETB  COL_LATCH
               CLR   COL_LATCH
               SETB  ROW_DATA
               CLR   ROW_DATA
               CLR   COL_ENABLE
               MOV   R5,#1
SCAN_DSP2:     MOV   R6,#00H
               DJNZ  R6,$
               DJNZ  R5,SCAN_DSP2
               DJNZ  B,SCAN_DSP1

               SETB  ROW_DATA
               CLR   ROW_DATA
               SETB  ROW_ENABLE
               RET
               
;*******************************************
;*         shift 8 bit data to 74595       *
;*******************************************
SER_OUT:       MOV   R2,#8                 ;set counter for 8 bit            
               CLR   C
SHF_OUT:       RRC   A                     ;shift lsb to carry flag
               MOV   COL_DATA,C            ;shift data 1 bit 
               NOP
               NOP
               SETB  COL_SHIFT             ;clock HI (74595)
               NOP
               NOP
               CLR   COL_SHIFT             ;clokc LO (74595) 
               NOP
               NOP
               DJNZ  R2,SHF_OUT            ;loop until 8 bit
               RET

               END



