;*****************************************
;* examples program for ET-LAB3A         *
;* description : read DS1820             *
;* compiler    : sxa51                   *
;*****************************************

             ORG     0000H         ;reset vector
             LJMP    MAIN

DATA_BIT     EQU     P0.1

PORT_LCD     EQU     P1
E_LCD        EQU     PORT_LCD.2        ;Enable LCD
WR_LCD       EQU     PORT_LCD.1        ;WR LCD
RS_LCD       EQU     PORT_LCD.0        ;RS Select LCD 

             ORG     25H
BUFFER:      DS      10

MAIN:        MOV     SP,#256-32    ; Initial Stack 32 Byte
             CLR     EA

             LCALL   DELAY         ; initial delay

             LCALL   INIT_LCD      ; initial LCD

             MOV     DPTR,#TEMP_TEXT
SSP1:        MOV     A,#0
             MOVC    A,@A+DPTR
             CJNE    A,#0DH,SSP
             LJMP    LOOP
SSP:         INC     DPTR
             LCALL   WRITE_DATA
             LJMP    SSP1


LOOP:        LCALL   READROM

             LCALL   SKIPROM

             LCALL   CONVERTTEMP
             LCALL   DELAY

             LCALL   SKIPROM
             LCALL   READSCRATCHPAD

             MOV     A,#08H
             LCALL   GOTOLCD

             MOV     R0,#BUFFER+0       ;READ POSITIVE TEMPERATUR ONLY
             MOV     A,@R0
             CLR     C
             RRC     A

             MOV     DPTR,#HEXDEC       ;HEX TO DEC
             MOVC    A,@A+DPTR

             PUSH    ACC
             SWAP    A
             ANL     A,#0FH
             LCALL   HEXASC
             LCALL   WRITE_DATA

             POP     ACC
             ANL     A,#0FH
             LCALL   HEXASC
             LCALL   WRITE_DATA

             LJMP    LOOP         



READROM:     LCALL   TOUCHRESET
             JNC     READROM

             MOV     A,#33H
             LCALL   TOUCHBYTE

             MOV     R7,#8
             MOV     R0,#BUFFER
ROMLOOP:     MOV     A,#0FFH
             LCALL   TOUCHBYTE
             MOV     @R0,A
             INC     R0
             DJNZ    R7,ROMLOOP
             RET


SKIPROM:     LCALL   TOUCHRESET
             JNC     SKIPROM

             MOV     A,#0CCH
             LCALL   TOUCHBYTE
             RET

CONVERTTEMP: MOV     A,#44H
             LCALL   TOUCHBYTE
             RET

READSCRATCHPAD: MOV    A,#0BEH
                LCALL  TOUCHBYTE

                MOV    R7,#9
                MOV    R0,#BUFFER
SCATCHLOOP:     MOV    A,#0FFH
                LCALL  TOUCHBYTE
                MOV    @R0,A
                INC    R0
                DJNZ   R7,SCATCHLOOP
                LCALL  TOUCHRESET
                RET


TOUCHRESET:
             PUSH   ACC                 ;     SAVE THE ACCUMULATOR
             MOV    A,#12               ;     LOAD OUTER LOOP VARIABLE
             CLR    DATA_BIT            ;     START THE RESET PULSE 
             MOV    R1,#3               ;
DELRESET:    MOV    R2,#245             ;2.   SET TIME INTERVAL
             DJNZ   R2,$                ;490. WAIT WITH DATA LOW
             DJNZ   R1,DELRESET         ;
             SETB   DATA_BIT            ;1.   RELEASE DATA LINE
             MOV    B,#20               ;2.   SET TIME INTERVAL
             CLR    C                   ;1.   CLEAR PRESENCE FLAG
WAITLOW:
             JB     DATA_BIT,WH         ;EXIT LOOP IF LINE HIGH
             DJNZ   B,WAITLOW           ;HANG AROUND FOR 3360
             DJNZ   ACC,WAITLOW         ;US IF LINE IS LOW
             SJMP   SHORT               ;LINE COULD NOT GO HIGH
WH:
             MOV    R1,#255             ;DELAY FOR PRESENCE DETECT
HL:
             ORL    C,/DATA_BIT         ;2.   CATCH PRESENCE PULSE
             DJNZ   R1,HL               ;510  WAIT WITH DATA HIGH
SHORT:
             POP    ACC                 ;RESTORE ACCUMULATOR
             RET                        ;RETURN



TOUCHBYTE:
             PUSH   B                   ;SAVE THE B REGISTER
             MOV    B,#8                ;SETUP FOR 8 BIT
BIT_LOOP:
             RRC    A                   ;GET BIT IN CARRY
             LCALL  TOUCHBIT            ;SEND BIT
             DJNZ   B,BIT_LOOP          ;GET NEXT BIT
             RRC    A                   ;GET FINAL BIT IN ACC
             POP    B                   ;RESTORE B REGISTER
             RET                        ;RETURN TO CALLER


TOUCHBIT:    CLR   DATA_BIT             ;1.     START THE TIME SLOT
             MOV   R1,#4                ;1.
             DJNZ  R1,$                 ;2 X 4  DELAY ~ 3 US

             MOV   DATA_BIT,C           ;1      SEND OUT THE DATA BIT
             MOV   R1,#10               ;1
             DJNZ  R1,$                 ;2 X 10 DELAY ~ 7 US

             MOV   C,DATA_BIT           ;1      SAMPLE INPUT DATA BIT
             MOV   R1,#90               ;1
             DJNZ  R1,$                 ;2 X 90 DELAY ~ 59 US
             SETB  DATA_BIT             ;TERMINATE TIME SLOT
             RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WRITE_INS:  MOV     B,A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            RET

WRITE_DATA: MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            RET 

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H       
            LCALL   WRITE_INS
            MOV     A,#32H       
            LCALL   WRITE_INS
            MOV     A,#28H        
            LCALL   WRITE_INS         
            MOV     A,#01H
            LCALL   WRITE_INS         
            MOV     A,#02H          
            LCALL   WRITE_INS          
            MOV     A,#0EH         
            LCALL   WRITE_INS          
            RET


GOTOLCD:    SETB   ACC.7
            LCALL  WRITE_INS
            RET

;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     SETB    E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            CLR     E_LCD           ;Disable LCD
            LCALL   BUSY
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#05H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET


;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    07H
            PUSH    06H
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            POP     06H
            POP     07H
            RET

;****************************************************
;*              convert hex to ascii                *
;****************************************************
HEXASC:     CJNE    A,#0AH,HEX
HEX:        JNC     MORE
            ADD     A,#30H
            RET
MORE:       ADD     A,#37H
            RET

HEXDEC:     DB        00H,01H,02H,03H,04H,05H,06H,07H,08H,09H
            DB        10H,11H,12H,13H,14H,15H,16H,17H,18H,19H
            DB        20H,21H,22H,23H,24H,25H,26H,27H,28H,29H
            DB        30H,31H,32H,33H,34H,35H,36H,37H,38H,39H
            DB        40H,41H,42H,43H,44H,45H,46H,47H,48H,49H
            DB        50H,51H,52H,53H,54H,55H,56H,57H,58H,59H
            DB        60H,61H,62H,63H,64H,65H,66H,67H,68H,69H
            DB        70H,71H,72H,73H,74H,75H,76H,77H,78H,79H
            DB        80H,81H,82H,83H,84H,85H,86H,87H,88H,89H
            DB        90H,91H,92H,93H,94H,95H,96H,97H,85H,99H

TEMP_TEXT:  DB   'TEMP =      C',0DH 

            END


