;******************************************
;* examples program for ET-LAB3A          *
;* description : read & write DS1307      *
;* compiler    : sxa51                    *
;******************************************
            ORG     0000H
            LJMP    RESET_VEC               ;reset vector

SCL         EQU     P0.0
SDA         EQU     P0.1

CONT_BW     EQU     0D0H
CONT_BR     EQU     0D1H

            ORG     25H
ADDRESS:    DS      1
DATA:       DS      1

PORT_LCD    EQU     P1              ;Port  LCD
E_LCD       EQU     PORT_LCD.2      ;Enable LCD
WR_LCD      EQU     PORT_LCD.1      ;WR LCD
RS_LCD      EQU     PORT_LCD.0      ;RS Select LCD 



RESET_VEC:  MOV     SP,#256-32
            CLR     EA

INIT_PORT:  SETB    SCL
            SETB    SDA

            CLR     WR_LCD          ;write LCD
            SETB    E_LCD           ;initial LCD

            LCALL   DELAY           ;initial delay

            LCALL   INIT_LCD        ;initial LCD

            MOV     DPTR,#TEXT
SSP2:       MOV     A,#0
            MOVC    A,@A+DPTR
            CJNE    A,#0DH,SSP
            LJMP    SSP1
SSP:        LCALL   WR_DATA
            INC     DPTR
            LJMP    SSP2

SSP1:       MOV     ADDRESS,#0
            MOV     DATA,#0
            LCALL   WRITE_BYTE

LOOP:       MOV     ADDRESS,#02H
            LCALL   READ_BYTE

            MOV     A,#40H
            LCALL   GOTO_LCD

            MOV     A,DATA
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     A,DATA
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     ADDRESS,#01H
            LCALL   READ_BYTE

            MOV     A,#43H
            LCALL   GOTO_LCD

            MOV     A,DATA
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     A,DATA
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA


            MOV     ADDRESS,#00H
            LCALL   READ_BYTE

            MOV     A,#46H
            LCALL   GOTO_LCD

            MOV     A,DATA
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     A,DATA
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA


            SJMP    LOOP


;*****************************************************
;*            WRITE DATA TO EEPROM 1 BYTE            *
;*      : DATA                                       *
;*****************************************************
WRITE_BYTE: CLR     SDA                    ;start bit
            CLR     SCL

            MOV     A,#CONT_BW             ;send control byte
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,WRITE_BYTE         ;loop until busy
            CLR     SCL
            NOP
            NOP

            MOV     A,ADDRESS              ;send address low
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,WRITE_BYTE         ;loop until busy
            CLR     SCL
            NOP
            NOP

            MOV     A,DATA                 ;send data
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,WRITE_BYTE         ;loop until busy
            CLR     SCL
            NOP
            NOP
            CLR     SDA

            SETB    SCL                    ;stop bit
            SETB    SDA
            LCALL   DELAY
            RET

;******************************************************
;*            READ DATA FROM EEPROM 1 BYTE            *
;* OUTPUT : DATA                                      *
;******************************************************
READ_BYTE:  CLR     SDA                    ;start bit
            CLR     SCL

            MOV     A,#CONT_BW             ;send control byte
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,READ_BYTE          ;loop until busy
            CLR     SCL
            NOP
            NOP

            MOV     A,ADDRESS              ;send address low
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,READ_BYTE         ;loop until busy
            CLR     SCL
            NOP
            NOP

            SETB    SCL

            CLR     SDA                    ;start bit
            CLR     SCL

            MOV     A,#CONT_BR             ;send control byte
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            NOP
            NOP
            JB      SDA,READ_BYTE          ;loop until busy
            CLR     SCL
            NOP
            NOP

            LCALL   GET_BYTE
            MOV     DATA,A

            SETB    SDA
            SETB    SCL                    ;NO ACK
            CLR     SCL

            CLR     SDA

            SETB    SCL                   ;stop bit
            SETB    SDA
            LCALL   DELAY
            RET


;****************************************************
;*                      WRITE                       *
;* INPUT: ACC                                       *
;****************************************************
PUT_BYTE:   PUSH    02H
            MOV     R2,#08H
PUT1:       RLC     A
            MOV     SDA,C
            SETB    SCL
            NOP
            NOP
            CLR     SCL
            NOP
            NOP
            DJNZ    R2,PUT1
            POP     02H
            RET

;*****************************************************
;*                       READ                        *
;* OUTPUT: ACC                                       *
;*****************************************************
GET_BYTE:   PUSH    02H
            MOV     R2,#08H
GET1:       SETB    SCL
            NOP
            NOP
            MOV     C,SDA
            CLR     SCL
            NOP
            NOP
            RLC     A
            DJNZ    R2,GET1
            POP     02H
            RET

;***************************************************
;*                     delay
;***************************************************
DELAY4M:    PUSH    DPH
            PUSH    DPL
            MOV     DPTR,#0000H
DEL4:       INC     DPTR
            MOV     A,DPL
            ORL     A,DPH
            JNZ     DEL4
            POP     DPL
            POP     DPH
            RET

;****************************************************
;*                Input  : ACC  (ASCII)             *
;*                Output : Data bus LCD             *
;****************************************************
WR_DATA:    MOV     B,A
            ANL     A,#0F0H
            ORL     A,#00000101B    ;RS/CS HI
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B
            ORL     A,R2
            MOV     PORT_LCD,A
            LCALL   EN_LCD
            MOV     A,B             ;Low byte
            SWAP    A
            ANL     A,#0F0H
            ORL     A,#00000101B
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B
            ORL     A,R2
            MOV     PORT_LCD,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WR_INS:     MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.2           ;E HI
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B    ;else bit
            ORL     A,R2
            MOV     PORT_LCD,A      ;High byte
            LCALL   EN_LCD
            MOV     A,B             ;Low byte
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.2
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B
            ORL     A,R2
            MOV     PORT_LCD,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                 Goto position of LCD             *
;*                 Input : ACC (addr.)              *
;****************************************************
GOTO_LCD:   SETB    ACC.7
            LCALL   WR_INS
            RET

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H          ;Set DL = 1 3-time
            LCALL   WR_INS
            MOV     A,#32H          ;Clear DL = 0 1-time
            LCALL   WR_INS
            MOV     A,#28H          ;Function set
            LCALL   WR_INS          ;DL=0 4Bit,N=1 2Line,F=0 5X7
            MOV     A,#0CH
            LCALL   WR_INS          ;Entry display,cursor off,cursor not blink
            MOV     A,#06H          ;Entry mode set
            LCALL   WR_INS          ;I/D=1 Increment,S=0 cursor shift
            MOV     A,#01H          ;Clear display
            LCALL   WR_INS          ;Clear display,set DD RAM address=0
            RET
;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     CLR     E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            SETB    E_LCD           ;Disable LCD
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#0AH
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    DPH
            PUSH    DPL
            PUSH    ACC
            MOV     DPTR,#0000H
DEL:        INC     DPTR
            MOV     A,DPL
            ORL     A,DPH
            JNZ     DEL
            POP     ACC
            POP     DPL
            POP     DPH
            RET

;**********************************************
;*         convert hex to ascii               * 
;**********************************************
HEXASC:     CJNE    A,#10,CHECK
CHECK:      JNC     MORE
            ADD     A,#30H
            RET
MORE:       ADD     A,#37H 
            RET

TEXT:       DB      'HH:MM:SS',0DH

            END














